/*----------------------------------------------------------------------------------------
Example program.
Purpose : Demonstrate how to render an heightfield with a SoHeightFieldRender.
----------------------------------------------------------------------------------------*/

//header files
#include <ScaleViz/SoScaleViz.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoPhysicalMaterial.h>
#include <Inventor/nodes/SoScale.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <VolumeViz/nodes/SoVolumeIsosurface.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <VolumeViz/nodes/SoHeightFieldGeometry.h>
#include <VolumeViz/nodes/SoHeightFieldProperty.h>
#include <VolumeViz/nodes/SoHeightFieldRender.h>
#include <LDM/nodes/SoMultiDataSeparator.h>
#include <LDM/nodes/SoTransferFunction.h>
#include <Inventor/sensors/SoTimerSensor.h>
#include <Inventor/stats/SoPerfCounterManager.h>
#include <Inventor/stats/SoPerfCounter.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoPickStyle.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoFontStyle.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>

#include <Inventor/helpers/SbFileHelper.h>

#include "utils.h"

// generated with LDMConverter -c jpeg -b 1 $OIVHOME/examples/data/VolumeViz/horizons/HorizonRGBA-elevation.lst
SbString GeometryFile = "$OIVHOME/examples/data/VolumeViz/horizons/HorizonRGBA-elevation.ldm";
// generated with LDMConverter -c gzip -b 1 $OIVHOME/examples/data/VolumeViz/horizons/HorizonRGBA-property.lst
SbString PropertyFile = "$OIVHOME/examples/data/VolumeViz/horizons/HorizonRGBA-property.ldm";
const SbVec3f defaultScaleFactor(1.f, 1.f, 0.01f);

SoText2* g_infoText = NULL;

/*******************************************************************************/
int main(int, char **argv)
{
  // Create the window
  SoTopLevelDialog *myTopLevelDialog;
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow) return 0;

  if ( !SoScaleViz::isRunningART() )
  {
    SoPreferences::setBool(SbString("OIV_PERFCOUNTER_ENABLE"), TRUE);
    SoPreferences::setString(SbString("OIV_PERFCOUNTER_OUTPUT"), "perfcounter.log");
  }

  // Initialize of VolumeViz extension
  SoVolumeRendering::init();
  SoDialogViz::init();

  // Add a scale on z
  SoScale* scale = new SoScale;
  scale->scaleFactor = defaultScaleFactor;

  // SoComplexity node is used to adjust tessellation level of HeightFieldRender and simplify rendering.
  SoComplexity* complexity = new SoComplexity;

  // Node to hold the property
  SoHeightFieldGeometry* hg = new SoHeightFieldGeometry();
  hg->fileName = GeometryFile;
  hg->dataSetId = 2;

  // Node to hold the heights
  SoHeightFieldProperty* hp = new SoHeightFieldProperty();
  hp->fileName = PropertyFile;
  hp->dataSetId = 1;

  SoHeightFieldRender* hf = new SoHeightFieldRender;

  SoMultiDataSeparator* mds = new SoMultiDataSeparator;
  mds->addChild(scale);
  mds->addChild(hp);
  mds->addChild(hg);
  mds->addChild(hf);

  SoTransferFunction* tf = new SoTransferFunction;
  tf->predefColorMap = SoTransferFunction::STANDARD;

  SoLightModel* lightModel = new SoLightModel;
  lightModel->model = SoLightModel::PHYSICALLY_BASED;

  //Material
  SoPhysicalMaterial* material = new SoPhysicalMaterial;
  material->baseColor = SbColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
  material->specular = 1.0f;
  material->roughness = 0.4f;

  // Assemble the scene graph
  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild(new SoPerspectiveCamera);

  root->addChild( new SoGradientBackground );
  root->addChild( new SoDirectionalLight ); // additional light source
  root->addChild( complexity );
  root->addChild( lightModel );
  root->addChild( material );
  root->addChild( tf );
  root->addChild( mds );

  SbString InterfaceFile = "$OIVHOME/examples/source/VolumeViz/simpleHorizonRGBA/interface.iv";
  Widget parent = buildInterface(myWindow, InterfaceFile.toLatin1(), "Viewer", &myTopLevelDialog);
  SoDialogIntegerSlider *slider;
  slider = (SoDialogIntegerSlider *)myTopLevelDialog->searchForAuditorId( "NumTris" );

  complexity->value.connectFrom( &slider->value );

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);
  myViewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Simple Horizon");
  myViewer->viewAll();
  myViewer->saveHomePosition();
  myViewer->show();

  myViewer->bindNormalContext();
  if (!SoHeightFieldRender::isSupported())
  {
    SoError::post("Some extensions are not supported on the current platform to launch this demo\n");
    return -1;
  }
  myViewer->unbindNormalContext();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();

  SoDialogViz::finish();
  SoVolumeRendering::finish();
  SoXt::finish();
  return 0;
}

