#ifndef UTILS_H
#define UTILS_H

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/actions/SoSearchAction.h>
#include <DialogViz/SoDialogVizAll.h>

extern SoSeparator *readFile(const char *filename);
extern Widget buildInterface(Widget window, const char *filename, const char* viewer,
                             SoTopLevelDialog** myTopLevelDialog);

extern void releaseInterface();

template<typename T>
T*
searchNode(SoNode* scene)
{
  SoSearchAction* sa = new SoSearchAction;
  sa->setType(T::getClassTypeId());
  sa->apply(scene);

  SoPath* path = sa->getPath();
  if ( !path )
  {
    std::cerr << T::getClassTypeId().getName().getString() << " not found" << std::endl;
    exit(0);
  }
  T* ret = dynamic_cast<T*>(path->getTail());
  delete sa;
  return ret;
}

#endif


