/*----------------------------------------------------------------------------------------
Example program.
Purpose : Demonstrate how to render an isosurface with a SoVolumeIsosurface property node
          a volumeData and a volumeRender node.
author : Benjamin Grange
September 2005
----------------------------------------------------------------------------------------*/

//header files
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <VolumeViz/nodes/SoVolumeIsosurface.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>

#define FILENAME "$OIVHOME/examples/data/VolumeViz/3DHEAD.ldm"

//main function
int main(int, char **argv)
{
  // Create the window
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow) return 0;
    
  // Initialize of VolumeViz extension
  SoVolumeRendering::init();

  // Node to hold the volume data
  SoVolumeData* pVolData = new SoVolumeData();
  pVolData->fileName = FILENAME;  

  // Node to hold the volume rendering quality
  SoVolumeRenderingQuality* pVolQuality = new SoVolumeRenderingQuality();
  pVolQuality->lighting.setValue( TRUE );
  pVolQuality->deferredLighting.setValue( FALSE );

  // Property node which allow SoVolumeRender to draw isosurface for
  // the isovalue 34
  SoVolumeIsosurface *pVRIsosurface = new SoVolumeIsosurface;
  pVRIsosurface->isovalues.set1Value(0, 34);

  // Node in charge of drawing the volume
  SoVolumeRender* pVolRender = new SoVolumeRender;
  pVolRender->numSlicesControl = SoVolumeRender::ALL;

  //Material which defines the isosurface diffuse color, transparency,
  //specular color and shininess
  SoMaterial *matVolRend = new SoMaterial;  
  matVolRend->diffuseColor.setValue(1,1,1);
  matVolRend->transparency.setValue( 0.0f ); 
  matVolRend->specularColor.setValue(1,1,1);
  matVolRend->shininess.setValue(0.5);    

  // Assemble the scene graph
  // Note: SoVolumeRender must appear after the SoVolumeData node.
  SoSeparator *root = new SoSeparator;
  root->ref();   
  root->addChild(new SoDirectionalLight);
  root->addChild( matVolRend );
  root->addChild( pVolData );
  root->addChild( pVolQuality );
  root->addChild( pVRIsosurface );
  root->addChild( pVolRender );

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setTransparencyType(SoGLRenderAction::NO_SORT);
  myViewer->setSceneGraph(root);    
  myViewer->setTitle("Isosurface rendering");
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoXt::finish();
  return 0;
}


