
// Simple fragment shader that implements a very simple Volume rendering
// and invert colors
//
// See reference documentation under Modules/VolumeViz/Shaders for more details about VViz shaders.


// As GLSL doesn't have a "#include" keyword like in C++,
// The "//!oiv_include" keywork is used to include header files in a GLSL file.
// These file are similar to C++ .h file. They contains various function declaration
// that you can call in your custom code.
// These file are located in OIVHOME/shaders/include directory.

//!oiv_include <VolumeViz/vvizfnc_frag.h>
//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>


// In GLSL, a uniform variable is a variable that is set by the CPU.
// It is some king of global variable. They are generally used to access to a texture or
// set a global value to the shader like a global transparency or a data id to use.
// It can be specified CPU side by using an SoShaderParameterX node.
// VVizDataSetId represent a VolumeData id.
uniform VVizDataSetId voldata;
uniform int transfer;


// VViz shader pipeline is composed of several "slot" that you can overload.
// See SoVolumeShader documentation for list of available slots.
// You can see a "slot" as a C++ virtual method that you have to redefine to customize vviz behavior.
// Here, VVizComputeFragmentColor() is the method associated with the FRAGMENT_COMPUTE_COLOR slot.
// See OIVHOME/shaders/include/VolumeViz/vvizComputeFragmentColor_frag.h for details.
vec4 VVizComputeFragmentColor(VVizDataSetId dataset, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int mask)
{
#if 1
  // get the data value at current position.
  // voxelInfoFront contains various information about current voxel.
  // for example, voxelInfoFront.texCoord is the voxel coordinate in VolumeData.
  // (0, 0, 0) is lower left bottom corner, (1, 1, 1) is upper right top corner.
  // VVizVoxelInfo structure is defined in OIVHOME/shaders/include/VolumeViz/vvizStructure.h file.
  //
  // VVizGetData return a VVIZ_DATATYPE object, which can be a float for scalar VolumeData or
  // a vec4 for color VolumeData (RGBA)
  VVIZ_DATATYPE sf = VVizGetData(voldata, voxelInfoFront.texCoord);

  // get the color for this value through the transfer function
  // Your scenegraph can contains several transfer function.
  // You can chose wich tranfer function to use with the "transfer" uniform value.
  // VVizTransferFunction() take a value and return corresponding color.
  vec4 res = VVizTransferFunction(sf, transfer);
#else
  // VolumeViz basic behavior: Apply transfer function, opacity correction and some other effects. 
  vec4 res = VVizComputeVolumeRendering(voxelInfoFront.value, mask);
#endif

  // invert color.
  // Here we keep the alpha value as is but invert the RGB component:
  // newRed = 1 - red, newGreen = 1 - green, newBlue = 1 - blue.
  res.xyz = vec3(1.) - res.xyz;
  
  return res;
}

