#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoShadowGroup.h>
#include <Inventor/SoPreferences.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>
#include <VolumeViz/nodes/SoVolumeIsosurface.h>
#include <VolumeViz/nodes/SoFenceSlice.h>
#include <Inventor/actions/SoSearchAction.h>

#include <DialogViz/SoDialogVizAll.h>

#include "utils.h"

#include <Inventor/STL/algorithm>
#include <cstdlib>

#include <Inventor/helpers/SbFileHelper.h>


SbString dataFile = "scene.iv";
SbString interfaceName = "interface.iv";
#define COLORMAPFILENAME "$OIVHOME/examples/data/VolumeViz/bonsai.txt"

void loadColormap(const char *filename, SoTransferFunction *tf);

/*********************************************************************************/
int main(int, char **argv)
{
  SoTopLevelDialog *myTopLevelDialog;
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;

  SoVolumeRendering::init();
  SoDialogViz::init();
  SoLDMGlobalResourceParameters::setViewCulling(FALSE);
  SoLDMGlobalResourceParameters::setViewpointRefinement(FALSE);
  SoLDMGlobalResourceParameters::setScreenResolutionCulling(FALSE);

  SoInput::addDirectoryFirst("$OIVHOME/examples/source/VolumeViz/simpleShadows");

  SoSeparator* scene = readFile(dataFile.toLatin1());
  if(!scene)
  {
    std::cerr << dataFile.toStdString() << "not found" << std::endl;
    return EXIT_FAILURE;
  }

  Widget parent = buildInterface(myWindow, interfaceName.toLatin1(), "Viewer", &myTopLevelDialog);

  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild(scene);

  SoTransferFunction* tf = searchNode<SoTransferFunction>(scene);
  loadColormap(COLORMAPFILENAME, tf);

  SoShadowGroup* sg = searchNode<SoShadowGroup>(scene);
  if ( !sg )
    return EXIT_FAILURE;

  SoDialogRealSlider *realSlider;
  realSlider = (SoDialogRealSlider *)myTopLevelDialog->searchForAuditorId("intensity");
  sg->intensity.connectFrom(&realSlider->value);

  SoDialogIntegerSlider *intSlider;
  intSlider = (SoDialogIntegerSlider *)myTopLevelDialog->searchForAuditorId("smoothness");
  sg->smoothFactor.connectFrom(&intSlider->value);

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Simple Shadows");
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  myTopLevelDialog->close();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}

void loadColormap( const char *colorFile, SoTransferFunction *tf )
{
  FILE *file;
  const int BUFSIZE = 256;
  char buf[BUFSIZE];

  file = SbFileHelper::open(colorFile, "r");

  int num_colors = 0;

  // Get first line of file and try to identify it.
  fscanf(file, "%d", &num_colors);
  fgets( buf, BUFSIZE, file );

  float rgba[256][4];

  int numComponents = 0;
  for (int i = 0; i < num_colors; ) {
    char line[256];
    fgets( line, 256, file );
    float color[4];
    numComponents = sscanf( line, "%g %g %g %g", &color[0], &color[1], &color[2], &color[3]);
    for (int k = 0; k < numComponents; k++)
      color[k] /= 65535.0f;
    rgba[i][0] = color[0];
    rgba[i][1] = color[1];
    rgba[i][2] = color[2];
    rgba[i][3] = color[3];
    i++;
  }
  fclose(file);

  int mode = 256 / num_colors;

  static float rgba256[256][4];
  int index = 0;
  for (int k = 0; k < num_colors; k++) {
    int k1 = k + 1;
    if (k1 >= num_colors) k1 = num_colors-1;
    for (int i = 0; i < mode; i++) {
      rgba256[index][0] = rgba[k][0] + (float)i/mode*(rgba[k1][0]-rgba[k][0]);
      rgba256[index][1] = rgba[k][1] + (float)i/mode*(rgba[k1][1]-rgba[k][1]);
      rgba256[index][2] = rgba[k][2] + (float)i/mode*(rgba[k1][2]-rgba[k][2]);
      rgba256[index][3] = rgba[k][3] + (float)i/mode*(rgba[k1][3]-rgba[k][3]);
      index++;
    }
  }

  tf->predefColorMap = SoTransferFunction::NONE;
  tf->colorMapType = SoTransferFunction::RGBA;
  tf->colorMap.setNum( 256 * 4 );
  tf->colorMap.setValues( 0, 256 * 4, &rgba256[0][0] );
}


