#include <QFileDialog>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/helpers/SbFileHelper.h>
#include <VolumeViz/nodes/SoVolumeData.h>

static SoSeparator *
readFile(const char *filename)
{
  // Open the input file
  SoInput mySceneInput;
  if (!mySceneInput.openFile(filename))
  {
    std::cerr << "Cannot open file " << filename << std::endl;
    return NULL;
  }

  // Read the whole file into the database
  SoSeparator *myGraph = SoDB::readAll(&mySceneInput);
  if (myGraph == NULL)
  {
    std::cerr << "Problem reading file" << std::endl;
    return NULL;
  }

  mySceneInput.closeFile();
  return myGraph;
}

//main function
int main(int argc, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;

  SoVolumeRendering::init();

  SbString filename;
  if ( argc != 2 )
  {
    QString oivhome(SoPreferences::getString("OIVHOME", "").toLatin1());
    QString selectedfile = QFileDialog::getOpenFileName(NULL, "Open Iv File", oivhome, "Iv Files (*.iv *.ivz)");
    if ( selectedfile.isEmpty() )
      return 0;
    filename = SbString(selectedfile.toLatin1().data());
  }
  else
  {
    filename = argv[1];
  }

  SoSeparator* scene = readFile(filename.toLatin1());
  if(!scene)
    return 0;

  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild(scene);


  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("SimpleVvizViewer");
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoXt::finish();
  return 0;
}


