#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/SoPreferences.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>
#include <Inventor/actions/SoSearchAction.h>

#include <DialogViz/SoDialogVizAll.h>

#include "utils.h"

#include <Inventor/STL/algorithm>

const SbString DATAFILE = "$OIVHOME/examples/source/VolumeViz/surfaceScalar/scene.iv";

SoVolumeRenderingQuality* g_vrq;

class InterfaceAuditor : public SoDialogAuditor
{
public:
  InterfaceAuditor(SoTopLevelDialog* topDialog){m_top = topDialog;}

private:
    SoTopLevelDialog* m_top;


  void dialogComboBox(SoDialogComboBox* cpt)
  {
    int selectedItem = cpt->selectedItem.getValue();
    SbString item = cpt->items[selectedItem];

    if (cpt->auditorID.getValue() == "method")
    {
      if ( item == "Surface Scalar" )
      {
        g_vrq->surfaceScalarExponent = 8;
        g_vrq->unnormalizedGradientExponent = 0;
      }
      else if ( item == "Unormalized gradients" )
      {
        g_vrq->surfaceScalarExponent = 0;
        g_vrq->unnormalizedGradientExponent = 8;
      }
      else
      {
        g_vrq->surfaceScalarExponent = 0;
        g_vrq->unnormalizedGradientExponent = 0;
      }
    }
  }

};

/*********************************************************************************/
int main(int, char **argv)
{
  SoTopLevelDialog *myTopLevelDialog;
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;

  SoVolumeRendering::init();
  SoDialogViz::init();
  SoLDMGlobalResourceParameters::setViewCulling(FALSE);
  SoLDMGlobalResourceParameters::setViewpointRefinement(FALSE);
  SoLDMGlobalResourceParameters::setScreenResolutionCulling(FALSE);

  SoSeparator* scene = readFile(DATAFILE.toLatin1());
  if(!scene)
  {
    std::cerr << DATAFILE << " not found" << std::endl;
    return 0;
  }

  SbString InterfaceName = "$OIVHOME/examples/source/VolumeViz/surfaceScalar/interface.iv";
  Widget parent = buildInterface(myWindow, InterfaceName.toLatin1(), "Viewer", &myTopLevelDialog);
  myTopLevelDialog->addAuditor(new InterfaceAuditor(myTopLevelDialog));


  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild(scene);

  g_vrq = searchNode<SoVolumeRenderingQuality>(scene);
  if ( !g_vrq )
  {
    std::cerr << "SoVolumeRenderingQuality not found" << std::endl;
    return 0;
  }


  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);
  myViewer->setSceneGraph(root);
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}


