/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/SoPreferences.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeDataDrawStyle.h>
#include <Inventor/actions/SoSearchAction.h>

#include <DialogViz/SoDialogVizAll.h>

#include "utils.h"

#include <Inventor/STL/algorithm>

const SbString DATAFILE = "$OIVHOME/examples/source/VolumeViz/volumeDataDrawStyle/scene.iv";

SoVolumeDataDrawStyle* g_vds;
SoTopLevelDialog *myTopLevelDialog;

class InterfaceAuditor : public SoDialogAuditor
{
public:
  InterfaceAuditor(SoTopLevelDialog* topDialog){m_top = topDialog;}

private:
    SoTopLevelDialog* m_top;


  void dialogCheckBox(SoDialogCheckBox* cpt)
  {
    SbBool state = cpt->state.getValue();

    if(cpt->auditorID.getValue() == "volume")
    {
      int bitmask = g_vds->style.getValue();;
      g_vds->style = state? (bitmask|SoVolumeDataDrawStyle::VOLUME_RENDER):(bitmask&~SoVolumeDataDrawStyle::VOLUME_RENDER);
    } else if(cpt->auditorID.getValue() == "iso")
    {
      int bitmask = g_vds->style.getValue();;
      g_vds->style = state? (bitmask|SoVolumeDataDrawStyle::ISOSURFACE):(bitmask&~SoVolumeDataDrawStyle::ISOSURFACE);
    }
  }

  };

/*********************************************************************************/
int main(int, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;

  SoVolumeRendering::init();
  SoDialogViz::init();
  SoLDMGlobalResourceParameters::setViewCulling(FALSE);
  SoLDMGlobalResourceParameters::setViewpointRefinement(FALSE);
  SoLDMGlobalResourceParameters::setScreenResolutionCulling(FALSE);

  SoSeparator* scene = readFile(DATAFILE.toLatin1());
  if(!scene)
  {
    std::cerr << DATAFILE << " not found" << std::endl;
    return 0;
  }

  SbString InterfaceName = "$OIVHOME/examples/source/VolumeViz/volumeDataDrawStyle/interface.iv";
  Widget parent = buildInterface(myWindow, InterfaceName.toLatin1(), "Viewer", &myTopLevelDialog);
  myTopLevelDialog->addAuditor(new InterfaceAuditor(myTopLevelDialog));


  SoSeparator *root = new SoSeparator;
  root->ref();
  root->addChild(scene);

  g_vds = searchNode<SoVolumeDataDrawStyle>(scene);
  if ( !g_vds )
  {
    std::cerr << "SoVolumeDataDrawStyle found" << std::endl;
    return 0;
  }

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);
  myViewer->setTransparencyType(SoGLRenderAction::NO_SORT);
  myViewer->setSceneGraph(root);
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}


