/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Dec 2010)
**=======================================================================*/
#ifndef _SO_OFFSCREEN_VOLUME_RENDER_CUSTOM_H_
#define _SO_OFFSCREEN_VOLUME_RENDER_CUSTOM_H_

#include <VolumeViz/nodes/SoOffscreenVolumeRender.h>

class SoOffscreenVolumeRenderCustom : public SoOffscreenVolumeRender
{
  SO_NODE_HEADER(SoOffscreenVolumeRenderCustom);

public:

  /** This field control iterative subox returned by getNextSubBox calls.
   * boxSize is subdivided according to this field. 
   * Default is 0 (only one box is generated).
   */
  SoSFVec3i32 boxSubdivision;

  /** Default constructor */
  SoOffscreenVolumeRenderCustom();

  /** Set the SoVolumeData where voxels are copied */
  void setResultVolumeData(SoVolumeData* volData)
  { m_resultVolData = volData; }

protected:

  /**
   * Called by extraction process to get iteratively the subbox inside boxSize to extract.
   * Default is to return only one complete box (boxSize)
   * @param box to extract in ijk space. It must be contained in boxSize
   * @return FALSE when no more subbox should be extract
   */
  virtual SbBool getNextSubBox(SbBox3i32& box);

  /** Method calls each time a subBox as been computed
  * if FALSE is returned then the whole process is aborted.
  */
  virtual void boxComputed(SoGLRenderAction* action, SoBufferObject* data, const SbBox3i32& box);

SoINTERNAL public:
  static void initClass();
  static void exitClass();

protected:
  /** Destructor */
  virtual ~SoOffscreenVolumeRenderCustom();

  template<typename T> void copyBox(SoBufferObject* data, const SbBox3i32& box);
  SoVolumeData* m_resultVolData;

private:
  void computeDefaultIjkSubBoxes();
  std::vector<SbBox3i32> m_subBoxesIjk;
  size_t m_remainingBox;
};

#endif //_SO_OFFSCREEN_VOLUME_RENDER_CUSTOM_H_


