#ifndef DRAWGEOMETRY_H
#define DRAWGEOMETRY_H

#include <Inventor/SbVec.h>
#include <Inventor/SbSphere.h>

/*********************************************************************************/
template<typename T>
void drawBox(T* dest, const SbVec3i32& dim, const SbBox3i32& box, T value)
{
  SbVec3i32 minb, maxb;
  box.getBounds(minb, maxb);

  SbVec3i32 boxLen = box.getSize();
  for ( int k= 0; k < boxLen[2]; k++ )
    for ( int j = 0; j < boxLen[1]; j++ )
      for ( int i = 0; i < boxLen[0]; i++ )
      {
        SbVec3i32 p = minb+SbVec3i32(i, j, k);
        p[0] = SbMathHelper::Clamp(p[0], 0, dim[0]-1);
        p[1] = SbMathHelper::Clamp(p[1], 0, dim[1]-1);
        p[2] = SbMathHelper::Clamp(p[2], 0, dim[2]-1);
        size_t offs = p[0]+(p[1]+p[2]*dim[1])*dim[0];
        dest[offs] = value;
      }
}

/*********************************************************************************/
template<typename T>
void drawSphere(T* dest, const SbVec3i32& dim, const SbSphere& sphere , T value)
{
  size_t offs = 0;
  for ( int k= 0; k < dim[2]; k++ )
    for ( int j = 0; j < dim[1]; j++ )
      for ( int i = 0; i < dim[0]; i++ )
      {
        SbVec3f pc = sphere.getCenter()-SbVec3f(i, j, k);
        if ( pc.length() <= sphere.getRadius() )
          dest[offs] = value;
        offs++;
      }
}


#endif


