#ifndef UTILS_H
#define UTILS_H

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/actions/SoSearchAction.h>
#include <DialogViz/SoDialogVizAll.h>

extern SoSeparator *readFile(const char *filename);
extern Widget buildInterface(Widget window, const char *filename, const char* viewer,
                             SoTopLevelDialog** myTopLevelDialog);
extern void releaseInterface();

template<typename T>
std::vector<T*>
searchNodes(SoNode* scene)
{
  SoSearchAction* sa = new SoSearchAction;
  sa->setType(T::getClassTypeId());
  sa->setInterest(SoSearchAction::ALL);

  sa->apply(scene);

  const SoPathList& path = sa->getPaths();
  if ( path.getLength() == 0 )
  {
    std::cerr << T::getClassTypeId().getName().getString() << " not found" << std::endl;
    exit(0);
  }

  std::vector<T*> ret;
  for ( size_t i = 0; i < (size_t)path.getLength(); i++ )
     ret.push_back(dynamic_cast<T*>(path[i]->getTail()));

  delete sa;

  return ret;
}

template<typename T>
T*
searchNode(SoNode* scene)
{
  SoSearchAction* sa = new SoSearchAction;
  sa->setFind(SoSearchAction::TYPE);
  sa->setSearchingAll(true);
  sa->setType(T::getClassTypeId());
  sa->apply(scene);

  SoPath* path = sa->getPath();
  if ( !path )
  {
    std::cerr << T::getClassTypeId().getName().getString() << " not found" << std::endl;
    delete sa;
    return(NULL);
  }
  T* ret = dynamic_cast<T*>(path->getTail());
  delete sa;
  return ret;
}

template<typename T>
T*
searchName(SoNode* scene, SbName name)
{
  if (!scene)
  {
    T* node=(T*)SoNode::getByName(name);
    if ( node )
      return node;
  }

  else
  {
    SoSearchAction* sa = new SoSearchAction;
    sa->setFind(SoSearchAction::NAME);
    sa->setSearchingAll(true);
    sa->setType(T::getClassTypeId());
    sa->setName(name);
    sa->apply(scene);

    SoPath* path = sa->getPath();
    if ( path )
    {
      T* ret = dynamic_cast<T*>(path->getTail());
      delete sa;
      return ret;
    }
    delete sa;
  }

  std::cerr << T::getClassTypeId().getName().getString() << " not found" << std::endl;
  return(NULL);
}


#endif


