#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/SoPreferences.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>
#include <VolumeViz/nodes/SoVolumeIsosurface.h>
#include <VolumeViz/nodes/SoFenceSlice.h>
#include <LDM/SoLDMTopoOctree.h>
#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/nodes/SoText2.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoTranslation.h>
#include <Inventor/nodes/SoFontStyle.h>
#include <Inventor/nodes/SoCallback.h>

#include <DialogViz/SoDialogVizAll.h>

#include "utils.h"

#include <Inventor/STL/algorithm>

#include <Inventor/helpers/SbFileHelper.h>
#include <Inventor/events/SoKeyboardEvent.h>
#include <Inventor/actions/SoRayPickAction.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/SoPickedPoint.h>
#include <VolumeViz/details/SoVolumeRenderDetail.h>
#include <Inventor/events/SoMouseButtonEvent.h>
#include <Inventor/events/SoLocation2Event.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/STL/iostream>
#include <Inventor/STL/sstream>

SoVolumeData* g_volumeData;
SoNode* g_sceneGraph;
SoText2* g_infoText = NULL;
bool g_mousePressed = false;

/** Color of picked voxel */
std::vector<SoMaterial*> g_materialVoxel;

/*******************************************************************************/
SoSeparator*
displayInfo()
{
  SoSeparator* infoSep = readFile("$OIVHOME/examples/source/VolumeViz/volumePickingGpu/info.iv");
  infoSep->ref();
  SoMaterial* voxel0Mat = searchName<SoMaterial>(infoSep, "VOXELMAT");
  g_materialVoxel.push_back(voxel0Mat);
  g_infoText = searchNode<SoText2>(infoSep);
  infoSep->unrefNoDelete();

  return infoSep;
}

/*********************************************************************************/
static void
myMouseMoveCB(void* /*data*/, SoEventCallback* eventCB)
{
  const SoEvent *event = eventCB->getEvent();
  if ( g_mousePressed )
  {
    const SbViewportRegion &myRegion = eventCB->getAction()->getViewportRegion();
    SoRayPickAction pickaction = SoRayPickAction(myRegion);
    pickaction.setPoint(event->getPosition());
    pickaction.setSceneManager(eventCB->getAction()->getSceneManager());
    pickaction.apply(g_sceneGraph);

    SoPickedPoint* p = pickaction.getPickedPoint();
    if ( !p )
      return;

    const SoVolumeRenderDetail* detail = dynamic_cast<const SoVolumeRenderDetail*>(p->getDetail());
    if ( !detail )
      return;

    std::vector<SbVec4ub> rgba;
    std::vector<SbVec3f> objPos;
    std::vector<SbVec3i32> dataPos;
    std::vector<SoLDMTileID> tileIds;
    //Ignore fully transparent voxels
    detail->getRgbaValues(rgba, objPos, dataPos, tileIds, 0);

    if ( !rgba.empty() )
    {
      g_materialVoxel[0]->diffuseColor.set1Value(0, rgba[0][0]/255.f, rgba[0][1]/255.f, rgba[0][2]/255.f);
      g_materialVoxel[0]->transparency.set1Value(0, 1.f-rgba[0][3]/255.f);

      int level = g_volumeData->getLDMTopoOctree()->level( tileIds[0] );

      g_infoText->string.deleteValues(0);
      std::ostringstream buffer;
      buffer << "Position IJK: " << dataPos[0];
      g_infoText->string.set1Value(0, SbString(buffer.str().c_str()));
      buffer.str("");
      buffer << "Position XYZ: " << objPos[0];
      g_infoText->string.set1Value(1, SbString(buffer.str().c_str()));
      buffer.str("");
      buffer << "RGBA: " << rgba[0];
      g_infoText->string.set1Value(2, SbString(buffer.str().c_str()));
      buffer.str("");
      buffer << "Tile Id: " << tileIds[0] << " Level: " << level;
      g_infoText->string.set1Value(3, SbString(buffer.str().c_str()));
    }
  }
  eventCB->setHandled();
}

/*********************************************************************************/
static void
myMousePressCB(void* data, SoEventCallback* eventCB)
{
  const SoEvent *event = eventCB->getEvent();

  if (SO_MOUSE_PRESS_EVENT(event, ANY))
  {
    g_mousePressed = true;
    myMouseMoveCB(data, eventCB);
  }
  else if( SO_MOUSE_RELEASE_EVENT(event, ANY))
  {
    g_mousePressed = false;
  }
  eventCB->setHandled();
}

/*********************************************************************************/
int main(int argc, char **argv)
{
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;

  SoVolumeRendering::init();
  SoDialogViz::init();
  SoLDMGlobalResourceParameters::setViewCulling(FALSE);
  SoLDMGlobalResourceParameters::setViewpointRefinement(FALSE);
  SoLDMGlobalResourceParameters::setScreenResolutionCulling(FALSE);
  SoLDMGlobalResourceParameters::setMaxTexMemory(2);

  SoSeparator* scene = readFile("$OIVHOME/examples/source/VolumeViz/volumePickingGpu/simpleVolumeRender.iv");
  if(!scene)
  {
    std::cerr << "simpleVolumeRender.iv not found" << std::endl;
    return 0;
  }

  scene->ref();
  g_volumeData = searchNode<SoVolumeData>(scene);
  scene->unrefNoDelete();

  if ( argc == 2 )
    g_volumeData->fileName = argv[1];

  SoEventCallback *eventCB = new SoEventCallback;
  eventCB->addEventCallback(SoMouseButtonEvent::getClassTypeId(), myMousePressCB);
  eventCB->addEventCallback(SoLocation2Event::getClassTypeId(), myMouseMoveCB);

  SoSeparator* root = new SoSeparator;
  root->ref();
  root->addChild( eventCB );
  root->addChild(scene);
  root->addChild(displayInfo());

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST);
  myViewer->setSceneGraph(root);
  myViewer->setTitle("Volume Picking Gpu");
  myViewer->viewAll();
  myViewer->saveHomePosition();
  myViewer->show();

  g_sceneGraph = myViewer->getSceneManager()->getSceneGraph();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}


