/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : 
**=======================================================================*/
#include <Inventor/actions/SoSearchAction.h>

#include <Inventor/nodes/SoCSGShape.h>

class SoGroup;
class SoNode;
class SoSeparator;
class SbString;
class SbBox3f;

// search a node by type
template<typename T>
T* 
searchNode(SoNode* scene)
{
  SoSearchAction* sa = new SoSearchAction;
  sa->setFind(SoSearchAction::TYPE);
  sa->setSearchingAll(true);
  sa->setType(T::getClassTypeId());
  sa->apply(scene);

  SoPath* path = sa->getPath();
  if ( !path )
  {
    std::cerr << T::getClassTypeId().getName().getString() << " not found" << std::endl;
    return(NULL);
  }
  return dynamic_cast<T*>(path->getTail());
}

// search a node by name
template<typename T>
T* 
searchName(SoNode* scene, SbName name)
{
  if (!scene)
  {
    T* node=(T*)SoNode::getByName(name);
    if ( node )
      return node;
  }
  else
  {
    SoSearchAction* sa = new SoSearchAction;
    sa->setFind(SoSearchAction::NAME);
    sa->setSearchingAll(true);
    sa->setType(T::getClassTypeId());
    sa->setName(name);
    sa->apply(scene);

    SoPath* path = sa->getPath();
    if ( path )
      return dynamic_cast<T*>(path->getTail());
  }

  std::cerr << T::getClassTypeId().getName().getString() << " not found" << std::endl;
  return(NULL);
}

SoSeparator* drawExtentBbox( const SbBox3f & volBox  );
void createSynthCircularExtrusions(  int depthIdx, SoGroup *appendTo, int num, const SbBox3f &bbox );
int createNPipes( SoGroup *appendTo, const SbBox3f &bbox, int num, const SbString &fname  );

