#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/nodes/SoFragmentShader.h>
#include <Inventor/nodes/SoProjection.h>
#include <Inventor/projection/SbSphericalProjection.h>

#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeShader.h>
#include <VolumeViz/nodes/SoTransferFunction.h>

#include <VolumeViz/readers/SoVRAmFileReader.h>

#include <iostream>
#include <sstream>
#include <limits>

#include <cassert>

#include <Inventor/helpers/SbFileHelper.h>

#define SHOW_VOLUME true

SbBool
readFile(const char *filename, SoNode*& root)
{
  // Open the input file
  SoInput mySceneInput;
  if ( !mySceneInput.openFile(filename) )
  {
    fprintf(stderr, "Cannot open file %s\n", filename);
    return false;
  }

  // Read the whole file into the database
  if ( !SoDB::read(&mySceneInput, root) )
  {
    fprintf(stderr, "Problem reading file\n");
    return false;
  }

  mySceneInput.closeFile();
  return true;
}

//main function
int
main(int /*argc*/, char **argv)
{
  // Create the window
  Widget myWindow = SoXt::init(argv[0]);
  if (!myWindow)
    return 0;

  // Initialize of VolumeViz extension
  SoVolumeRendering::init();

  SoLDMGlobalResourceParameters::setVisualFeedbackParam(SoLDMGlobalResourceParameters::DRAW_TILES, SHOW_VOLUME);


  SoSeparator* root = new SoSeparator;
  SoNode* scene = NULL;
  root->ref();
  SbString SceneFileName = "$OIVHOME/examples/source/VolumeViz/volumeProjection/scene.iv";
  readFile(SceneFileName.toLatin1(), scene);

  root->addChild(scene);

  SoProjection *projection = dynamic_cast<SoProjection*>(SoNode::getByName("Projection"));
  float zMax = 1.f;
  if (projection && projection->projTypeId.getValue() != 0) {
    //SoDebugError::postInfo("main", "Projection type is not spherical");
    zMax = 5000.f;
  }

  SoVolumeData *pVolData = dynamic_cast<SoVolumeData*>(SoNode::getByName("VolumeData"));
  if ( pVolData )
  {
    //SoDebugError::postInfo("main", "setting volume data dimensions");
    pVolData->extent = SbBox3f(-90.f, -25.f, 0.f, 90.f, 25.f, zMax);
  }
  SoLDMGlobalResourceParameters::setScreenResolutionCulling(false);
  SoLDMGlobalResourceParameters::setViewpointRefinement(false);
  SoLDMGlobalResourceParameters::setViewCulling(false);

  SoTransferFunction *transferFunction = dynamic_cast<SoTransferFunction *>(scene->getByName("ColorMap"));
  if (transferFunction) {
    //SoDebugError::postInfo("main", "Remapping transfert function");
    transferFunction->minValue.setValue(18);
    transferFunction->maxValue.setValue(255);
  }

  // Set up viewer:
  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(myWindow);
  myViewer->setSceneGraph(root);
  std::ostringstream title;
  title << "Projected Volume Rendering";

  myViewer->setTitle(title.str().c_str());
  myViewer->show();

  SoXt::show(myWindow);
  SoXt::mainLoop();
  delete myViewer;
  root->unref();
  SoVolumeRendering::finish();
  SoXt::finish();
  return 0;
}


