/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (MMM yyyy)
**=======================================================================*/
#ifndef  _VOLUME_TRANSFORMER_H_
#define  _VOLUME_TRANSFORMER_H_


#include <VolumeViz/nodes/SoVolumeTransform.h>

#include <LDM/SoLDMTileID.h>
#include <Inventor/fields/SoSFDouble.h>
#include <Inventor/fields/SoSFEnum.h>

/** Forward declarations */
class SoArithmetic;
class SoCpuBufferObject;
class SoVolumeData;
class SoPerfCounter;

// When building the node as a DLL under Win32 we must explicitly
// declare this entry point as visible outside the DLL.
// The macro BUILDING_DLL is defined in the node's source file.
#ifdef BUILDING_DLL
  #define DLL_EXPORT VC_DLL_EXPORT
#else
  #define DLL_EXPORT VC_DLL_IMPORT
#endif
   
/**
 * Custom volume transform nodes example.
 */
class DLL_EXPORT volumeTransformer : public SoVolumeTransform
{
  SO_NODE_HEADER( volumeTransformer );

 public:

  /**
   * Scale factor applied to the input data.
   */
  SoSFDouble scaleFactor;

  /**
   * Constructor.
   */
  volumeTransformer();

  /**
   * Apply in place transformation of the given tile.
   *
   * @param ds reference the concerned dataset
   * @param bufferObject is the buffer we have to change in place
   * @param id Tile id we are working on
   */
  virtual void apply(SoState *state, const SoLDM::DataSetIdPair& p, SoBufferObject *bufferObject , const SoLDMTileID &id);

  /**
   * Check if given parameters are valid for this compute function.
   * If not the compute function won't be applied.
   *
   * @return TRUE if apply should be called.
   */
  virtual SbBool isValid(SoState *state, const SoLDM::DataSetIdPair& p, SoBufferObject *bufferObject , const SoLDMTileID &id);

  /**
   * Base on performance counter, return computation bandwith for CPU mode in MBytes/secs.
   * Note: After this calls performance counter are reset.
   */
  static void getStats(double* bandwidthCPU);

  /** Register node in database. */
  static void initClass();

  /** Unregister node from database. */
  static void exitClass();

protected:

  /** CPU version of the volume transform. */
  virtual void apply( SoState *, const SoLDM::DataSetIdPair& p, SoCpuBufferObject *bufferObject , const SoLDMTileID &tileID);

  /** Destructor. */
  virtual ~volumeTransformer();

private:

  static SoArithmetic  *s_cpuArithmeticInterface;

  /** Performance counter */
  static SoPerfCounter *s_TimeCounterCPU;
  static SoPerfCounter *s_DataCounterCPU;
};

#endif // _VOLUME_TRANSFORMER_H_


