@page HowToBuildCppExamples How to build C++ examples

# Introduction

On Windows, we provide all necessary Visual Studio projects with the src code of each example so that you can easily recompile any example with Visual Studio and skip the paragraph "Project generation using CMake GUI". However, this is not true for examples using QT, so you should read this paragraph to build the necessary Visual Studio projects

On Linux, you must build all example projects by using **CMake** on the host computer.

**CMake** is used to control the software compilation process using simple platform and compiler-independent configuration files (see CMakeLists.txt in each example directory).
Most rules for specific platforms and architecture are built-in in **CMake** modules, but all of them can be specifically configured depending on needs. All Open Inventor example-specific rules can be found in the installed **CMake** directory.

**CMake** generates native Makefiles or Visual Studio projects/solutions that can be used in the compiler environment of your choice.

For detailed information on CMake, please see the [official CMake website](https://cmake.org).

# Prerequisites

The following packages must be installed before project files can be generated for the examples.

- **CMake (for Linux and optional for Windows)**: See linux system requirements for C++ API part of the [Platforms and system requirements](#InventorPlatforms) corresponding to your version, for more details about CMake version.
- **Qt (optional)**: If you want Qt-based examples to be built you must install the Qt package. Installers can be found on the official [Qt website](http://www.qt.io/download/).
- **CUDA (optional)**: If you want CUDA based examples to be built, you must install the package for your specific GPU. Installers can be found on the official website of your GPU providers.
- **Windows 10 SDK (for Windows)**: On Windows 10 you need to have Windows 10 SDK 10.0.16299.0 installed to be able to use directly the .vcxproj files provided in the installer. If it is not installed, you will receive an error message saying *"error MSB8036: The Windows SDK version 10.0.16299.0 was not found. Install the required version of Windows SDK or change the SDK version in the project property pages or by right-clicking the solution and selecting "Retarget solution""*. To fix the issue simply run Visual Studio 2022 installer (C:\\Program Files (x86)\\Microsoft Visual Studio\\Installer\\vs_installer.exe if default installation), click on modify, and select 16299 SDK under SDK/framework in individual components tab of the installer

# Environment variables {#howToBuildExample_envVar}

Before generating and building example projects, the following environment variables must be properly set:

- **OIVHOME** must be set to the Open Inventor home installation folder (e.g. D:\\OpenInventorC++202510-Windows-Visual2022-x86_x64 for example).
- **OIVARCH** must be set to the Open Inventor version (e.g. arch-Linux-x86_64-gcc9-release, arch-Windows-x86_64-msvc17-Release and so on).
- **LD_LIBRARY_PATH**: Only for Linux. This variable must be set to $OIVHOME/$OIVARCH/lib
- **CMAKE_PREFIX_PATH**: Only if you want to generate Qt examples. This variable mut be set to directory where Qt5Config.cmake/Qt6Config.cmake can be found (e.g. C:\\Qt\\Qt6.5.3\\6.5.3\\msvc2019_64\\lib\\cmake\\Qt6 for example)

Here is how to define these variables depending on the Operating System you are running:

- On Windows (batch command line) :
  - set OIVHOME="<path to Open Inventor>"
  - set OIVARCH="arch-Windows-x86_64-msvc14-Release"
  - Qt Only : set CMAKE_PREFIX_PATH="<path to Qt\lib\cmake\QtX\>"

- On linux :
  - export OIVHOME="<path to Open Inventor>"
  - export OIVARCH="arch-Linux-x86_64-gcc48-release"
  - export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:$OIVHOME/$OIVARCH/lib"
  - Qt Only : export CMAKE_PREFIX_PATH="<path to Qt/lib/cmake/QtX/>"

# Compilation of examples

On windows:

- Open the requested solution or project with Visual Studio, compile, and run it.

On linux:

- You have to do the [Project generation using CMake GUI](#howToBuildExample_projectGeneration) before this step.
- After that, you can compile examples using **make** command and run the examples.

# Project generation using CMake GUI {#howToBuildExample_projectGeneration}

Below are the steps to use **CMake GUI** tool provided by the **CMake** installer.

- Set [environment variables](#howToBuildExample_envVar).
- Run cmake-gui
- Set up the Open Inventor examples input directory **"Where is the source code"** (e.g. E:/OIV/OpenInventorC++2025.1.0-Windows-Visual2022-x86_64/example).
- Set up the output directory **"Where to build the binaries"** where all generated files will be stored (e.g. E:/build/tests).
- Press the **Configure** button.
- **CMake** allows you to select the compiler version project target among those installed on the machine (e.g.: Visual Studio 17 2022 or Makefiles)
- After this step, **CMake** has checked the compiler options and library dependencies on your host computer, and allows you to customize some values. Most of the time no changes are required. However, if desired, you can change default compiler options, set different paths to third party libraries, or just check that everything has been found correctly using this GUI.
- **Qt only**: It's possible that CMake does not find your Qt installation. In this case it will display an error about not able to find Qt5Config.cmake or Qt6Config.cmake. In such case, verify that you have specified the environment variable CMAKE_PREFIX_PATH (see [environment variables](#howToBuildExample_envVar)). After that, enter Qt5_DIR or Qt6_DIR in the Search text box. CMake will show the actual value of this variable which will either not be set (value set to QT5/QT6_DIR-NOTFOUND) or wrongly set. Click on the button on the right in front of the variable name, it will allow you to specify where is located your Qt installation. Important note : the folder you must select is the one where Qt CMakefiles are located. It might be something like \<Your Qt Installation Folder\>/../../lib/cmake/Qt5)
- If an error occurs, you are warned about it so that you can fix it and press the **Configure** button again. Repeat as necessary until the "Configuring done" message appears and no longer errors are shown.
- **Linux only**: Next step is to specify which build type you want. For this, in Search text box just enter CMAKE_BUILD_TYPE and press Enter. Just as before **CMake** will show the value of the variable and it must be empty. You can enter **Release** or **Debug** depending on what you intend to do with the demo. Below we decided to build the Release version of the examples. Do not forget to click on Configure for the change to be taken in account.
- Press the **Generate** button, **CMake** will generate all Makefiles or Projects/Solutions for all examples in the selected output directory.

# Creating/Modifying a project

- To modify an existing project, edit the CMakeLists.txt file located in the source folder of the demos. Do not edit the project files, Makefiles or Visual studio project files (.vcproj/.sln or .vcxproj/.sln) directly, as **CMake** manages dependencies and they are rebuilt automatically when CMakeLists.txt files are changed.
- To create a new project or solution, see the CMakeLists.txt file for existing examples, or go to **CMake** official documentation website

# CMake error tips

- If **OIVHOME** and **OIVARCH** are not set, or wrongly set, CMake will be unable to find Open Inventor binaries needed to generated the demo projects and will generate an error. Be sure these two variables are well defined.
- **With Linux**: it is important to have this CMAKE_BUILD_TYPE=Release for release version and CMAKE_BUILD_TYPE=Debug for debug version.
- Verify paths to third party libraries, see page [Platforms and system requirements](InventorPlatforms) corresponding to your version.
- For **QT** make sure the installation has been done properly and that Qt installer updated your environnement variable with correct value (this value are used by CMake to retrieve needed Qt information).
