/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Apr 2003)
**=======================================================================*/
#ifndef  _SO_DIALOG_WIDGET_LIST_
#define  _SO_DIALOG_WIDGET_LIST_

#include <Inventor/SbPList.h>
#include <Inventor/Xt/SoXt.h>

class DIALOGVIZ_API SoDialogWidgetList : public SbPList {
 public:
  /**
   * Constructor.
   */
  SoDialogWidgetList();
  /**
   * Constructor that pre-allocates storage for @B size @b pointers.
   */
  SoDialogWidgetList(int size);
  /**
   * Constructor that copies the contents of another list.
   */
  SoDialogWidgetList(const SoDialogWidgetList &l);
  /**
   * Destructor.
   */
  ~SoDialogWidgetList();

  /**
   * Adds a pointer to the end of the list.
   */
  void append(SoWidget ptr);

  /**
   * Inserts given pointer in list before pointer with given index.
   */
  void insert(SoWidget ptr, int addBefore);

  /**
   * Returns index of given widget in list, or -1 if not found.
   */
  int find(const SoWidget ptr) const;

  /**
   * Copies a list.
   */
  SoDialogWidgetList & operator = (const SoDialogWidgetList &l);

  /** @copydoc SbPList::operator[]() */
  SoWidget& operator [](int i) const;

  /**
   * Sets an element of a list.
   */
  void set(int i, SoWidget& ptr);
};

#endif // _SO_DIALOG_WIDGET_LIST_


