/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Oct 2002)
**=======================================================================*/
#ifndef  _SO_AUDITOR_
#define  _SO_AUDITOR_

#include <Inventor/SoTypedObject.h>
#include <DialogViz/auditors/SoSubAuditor.h>

/**
 * @VSGEXT Base class for all auditors.
 * 
 * @ingroup Auditors
 * 
 * @DESCRIPTION
 *   SoAuditor is the base class for auditors in the DialogViz auditor model. An auditor
 *   typically represents a user action, such as a mouse button being pressed or a
 *   keyboard key being released.
 *   
 * @SEE_ALSO
 *   SoDialogAuditor,
 *   SoDialogCheckBoxAuditor,
 *   SoDialogComboBoxAuditor,
 *   SoDialogEditTextAuditor,
 *   SoDialogIntegerSliderAuditor,
 *   SoDialogPushButtonAuditor,
 *   SoDialogRadioButtonsAuditor,
 *   SoDialogRealSliderAuditor,
 *   SoMenuCheckBoxAuditor,
 *   SoMenuFileSelectionAuditor,
 *   SoMenuPushButtonAuditor,
 *   SoMenuRadioButtonsAuditor
 *
 * 
 */
class DIALOGVIZ_API SoAuditor: public SoTypedObject {
 public:
  
  /**
   * Returns the type id for this event instance.
   */
  virtual SoType      getTypeId() const;
    
  /**
   * Returns the type id for the SoEvent class.
   */
  static SoType       getClassTypeId();
    
 SoINTERNAL public:
  // Initializes base event class
  static void         initClass();
  static void         exitClass();

  // Initialize ALL Inventor auditor classes
  static void         initClasses();
  static void         exitClasses();
    
 protected:
  /**
   * Constructor.
   */
  SoAuditor();
  /**
   * Destructor.
   */
  virtual ~SoAuditor();

 private:
  static SoType       classTypeId; // base typeId for all auditors
};


#endif /* _SO_AUDITOR_ */

