/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Oct 2002)
**=======================================================================*/
#ifndef  _SO_DIALOG_CUSTOM_
#define  _SO_DIALOG_CUSTOM_

#include <DialogViz/dialog/SoDialogComponent.h>

/**
 * @VSGEXT Dialog Custom node.
 * 
 * @ingroup Dialog
 * 
 * @DESCRIPTION
 *   This node creates a widget that can be used as a container for 
 *   building another widget inside. This node can manage only one
 *   widget. See the Example section below.
 * 
 * @FILE_FORMAT_DEFAULT
 *   DialogCustom {
 *   @TABLE_FILE_FORMAT
 *       @TR // fields from SoDialogComponent
 *       @TR width            @TD 0
 *       @TR height           @TD 0
 *       @TR fixedWidth       @TD FALSE
 *       @TR fixedHeight      @TD FALSE
 *       @TR minWidth         @TD 0
 *       @TR maxWidth         @TD 0
 *       @TR minHeight        @TD 0
 *       @TR maxHeight        @TD 0
 *       @TR margin           @TD 0
 *       @TR edgeStyle        @TD NONE
 *       @TR labelVisibility  @TD TRUE
 *       @TR // fields from SoDialogViz
 *       @TR enable           @TD TRUE
 *       @TR label            @TD ""
 *       @TR labelAlignment   @TD RIGHT
 *       @TR auditorID      @TD ""
 *   @TABLE_END
 *   }
 *
 * @EXAMPLE
 *    Here is an example of how assign a widget to the SoDialogCustom, and use it.
 * 
 *  \code
 *      // create and build the dialog scene graph
 *      SoTopLevelDialog * myTopLevelDialog = new SoTopLevelDialog();
 *      
 *      SoDialogCustom * myDialogCustom = new SoDialogCustom();
 *      myTopLevelDialog->addChild(myDialogCustom);
 *      myTopLevelDialog->buildDialog( parent, buildInsideParent );
 *      myTopLevelDialog->show();
 *
 *      // Set an examinerViewer in the dialogCustom component.
 *      // Here, we have to get the custom widget and set it has the parent of the 
 *      // new widget. (For examiner viewer, pass TRUE as third param to build inside parent.)
 *      SoXtExaminerViewer* myViewer = new SoXtExaminerViewer(custom->getWidget(), "", TRUE);
 *      
 *      // Add a scene graph in viewer and show.
 *      myViewer->setSceneGraph(new SoCube());
 *      myViewer->show();
 *  \endcode
 *
 * @SEE_ALSO
 *   SoDialogCheckBox,
 *   SoDialogCheckBoxLauncher,
 *   SoDialogComboBox,
 *   SoDialogRadioButtons,
 *   SoDialogEditText,
 *   SoColumnDialog,
 *   SoRowDialog,
 *   SoTabDialog,
 *   SoDialogLabel,
 *   SoDialogPushButton,
 *   SoDialogPushButtonLauncher,
 *   SoDialogSeparator,
 *   SoDialogIntegerSlider,
 *   SoDialogRealSlider 
 *
 */
class DIALOGVIZ_API SoDialogCustom : public SoDialogComponent  
{
  SO_DG_HEADER(SoDialogCustom);

 public:
  /**
   * Constructor
   */
  SoDialogCustom();

  /**
   *  Returns the custom base widget.
   */
  SoWidget getWidget();

  /*==============================================================================*/
 SoINTERNAL public:
  static  void initClass();
  static  void exitClass();
  virtual void buildWidget(SoWidget parent, SbVec2i32 &rSize, SbVec2i32 & pos, SbBool isActive2d);
  void addChildWidget();

 protected:
  virtual ~SoDialogCustom();

 private:
  SoWidget m_childWidget;

  virtual void changeEdgeStyle();
};

#endif // _SO_DIALOG_CUSTOM_


