/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Jan 2003)
**=======================================================================*/
#ifndef  _SO_MESSAGE_DIALOG_
#define  _SO_MESSAGE_DIALOG_

#include <DialogViz/dialog/SoDialogViz.h>
#include <Inventor/threads/SbThread.h>

/**
 * @VSGEXT Message Dialog node.
 *
 * @ingroup Dialog
 * 
 * @DESCRIPTION
 * 
 * @SEE_ALSO
 *
 */
class DIALOGVIZ_API SoMessageDialog : public SoDialogViz  
{
  SO_DG_HEADER(SoMessageDialog);

 public:

  enum Type {
    /** Display the Error symbol. */
    MD_ERROR,
    /** Display the international information symbol (an "i" with a circle around it). */
    MD_INFORMATION,
    /** Display the default message symbol. */
    MD_MESSAGE,
    /** Display the question symbol (a "?" in a circle). */
    MD_QUESTION,
    /** Display the warning symbol (a "!" is displayed)*/
    MD_WARNING,
    /** Display a working window*/
    MD_WORKING
  };
  /**
   * Control the message dialog box type.
   */
  SoSFEnum type;
  
  /**
   * Constructor
   */
  SoMessageDialog();

  /**
   * Special constructor : build the message dialog box with text, title
   * and type properties, and show it next.
   */
  SoMessageDialog(SbString MDText, SbString MDTitle, Type MDType );

  /**
   * Title of the message dialog box
   */
  SoSFString title;

  /**
   * Show the MessageDialog widget.
   */
  virtual void show();

  /**
   * Close the current working message dialog. Only used with message dialog of type MD_WORKING
   */
  virtual void close();

  /**
   * Destroy the message dialog.
   */
  void destroy();

  /*==============================================================================*/
 SoINTERNAL public:

  void     * m_wnd;
  void     * m_wndLabel;
  SbThread * m_thread;

  static void initClass();
  static void exitClass();
  void createWorkingMessageDialog();

 protected:
    
  virtual  ~SoMessageDialog();

 private:
  static SbVec2i32 getLabelPixelSize(SbString string);
};

#endif // _SO_MESSAGE_DIALOG_


