/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Oct 2002)
**=======================================================================*/
#ifndef  _SO_TOP_COMPONENT_
#define  _SO_TOP_COMPONENT_

#include <DialogViz/dialog/SoDialogViz.h>

class SoTranslation;

/**
 * @VSGEXT Abstract Class for DialogViz visual components.
 *
 * @ingroup Dialog
 * 
 * @DESCRIPTION
 *    All top components may be added into a top level dialog (SoTopLevelDialog).
 * 
 * @SEE_ALSO
 *    SoTopLevelDialog,
 *    SoDialogComponent,
 *    SoMenuBar
 *
 */
class DIALOGVIZ_API SoTopComponent : public SoDialogViz
{
  SO_DG_HEADER(SoTopComponent);

 public:
/*==============================================================================*/
SoINTERNAL public:
  virtual void buildWidget(SoWidget parent, SbVec2i32 &rSize, SbVec2i32 & pos, SbBool is2dRender);
  virtual void getSize(SbVec2i32 &size, SbVec2i32 &min, SbVec2i32 &max);
  static  void initClass();
  static  void exitClass();
  virtual void updateFromSensor(SoSensor* sensor);
  virtual void  destroyWidget();

 protected:
  SoTopComponent();
  virtual      ~SoTopComponent();


///////////////////////////////////////////////////////////////////////////////////////
// 3D methods
SoINTERNAL public:
  void addTranslation(SoTranslation* tsl);

protected:

private:

///////////////////////////////////////////////////////////////////////////////////////
};

#endif // _SO_TOP_COMPONENT_


