/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/




#ifndef _SO_HARDCOPY_
#define _SO_HARDCOPY_

#include <SoVersion.h>
#include <HardCopy/SoHardCopyLibName.h>
#ifdef _WIN32
#  ifndef HardCopy_EXPORTS
#    ifndef OIV_DISABLE_AUTOLINK
#      pragma comment(lib,__HARDCOPYLIB)
#    endif
#  endif
#endif

#include <Inventor/SbBasic.h>

#include <Inventor/SoModule.h>
SO_MODULE_HEADER(SoHardCopy, __HARDCOPYDLL)

/**
 * @HCEXT Class to initialize HardCopy.
 * 
 * @ingroup HardCopy
 * 
 * @DESCRIPTION
 *   This class allows the user to initialize the HardCopy module. The module
 *   must be initialized before using any other classes of the module.
 * 
 * @SEE_ALSO
 *    HardCopy Overview,
 * 
 * 
 */
class HARDCOPY_API SoHardCopy {

 public:

  /**
   * Initializes all classes of HardCopy by registering them
   * in the database. This function needs to be called before any 
   * other class of HardCopy may be constructed or accessed. 
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void init();

  /** 
   * Frees Open Inventor's internal static memory 
   * allocations. This avoids false positives from memory
   * leak checking software. We recommend calling this method
   * and it should be the last Open Inventor method called by
   * the application.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void finish();

  /**
   * Returns a character string identifying the name of the extension.
   */
  static const char *getProductName();

#if SoDEPRECATED_BEGIN(2023200)
  /**
   * Returns a character string identifying the version of the extension.
   */
  SoDEPRECATED_METHOD(2023.2, "This method should no longer be used. Use SoLicensesInfo::getVersion() method instead.")
  static const char *getVersion();
#endif /** @DEPRECATED_END */

 SoINTERNAL public:

  static SbBool internalInit();

  // reference counter on the lib.
  static int s_initRefCount;

  static const char *s_versionString;

};
/*---------------------------------------------------------------------------*/

#endif // _SO_HARDCOPY_

