/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef SO_TO_PDF_ACTION_H
#define SO_TO_PDF_ACTION_H

#include <HardCopy/SoToU3DAction.h>

#include <Inventor/SbColor.h>
#include <Inventor/actions/SoSubAction.h>
#include <HardCopy/SoHardCopy.h>

class SoToPDFActionPrivate;

/**
 * @HCEXT Class for exporting a scene graph to a PDF file.
 * 
 * @ingroup HardCopy
 * 
 * @DESCRIPTION
 * This class can export an Open Inventor scenegraph into a simple PDF file.
 * In addition to 3D scene encapsulation, the exporter can insert a title to the document
 * and an unique block of text. Moreover, PDF encryption can lock access to the file contents.
 * To import a 3D model inside a more complex PDF file, prefer SoToU3DAction.
 * U3D files can be used to import 3D models inside PDF files by advanced PDF editors.
 * 
 * @B Limitations @b
 *  - Inherits limitations of SoToU3DAction. Please read these carefully.
 * 
 * @B Use case @b
 * \if_cpp
 *  \code
 *   SoHardCopy::init();
 *   ...
 *   // setup the root scene graph to export
 *   SoSeparator* root = new SoSeparator;
 *   ...
 *   SoToPDFAction pdfAction;
 *   bool result = pdfAction.openFile( "output.pdf" );
 *   if ( !result ) 
 *   {
 *     // error management
 *   }
 *   pdfAction.setTitle( "Scene Name" );
 *   pdfAction.setText( "Some text describing the exported scene." );
 *   pdfAction.apply( root );
 *   result = pdfAction.closeFile();
 *   if ( !result )
 *   {
 *     // error management
 *   }
 *  \endcode
 * \endif
 * \if_dotnet
 *  \code
 *   // setup the root scene graph to export
 *   SoSeparator root = new SoSeparator();
 *   ...
 *   SoToPDFAction pdfAction = new SoToPDFAction();
 *   bool result = pdfAction.OpenFile( "output.pdf" );
 *   if ( !result ) 
 *   {
 *     // error management
 *   }
 *   pdfAction.SetTitle( "Scene Name" );
 *   pdfAction.SetText( "Some text describing the exported scene." );
 *   pdfAction.Apply( root );
 *   result = pdfAction.CloseFile();
 *   if ( !result )
 *   {
 *     // error management
 *   }
 *  \endcode
 * \endif
 * \if_java
 *  \code
 *   // setup the root scene graph to export
 *   SoSeparator root = new SoSeparator();
 *   ...
 *   SoToPDFAction pdfAction = new SoToPDFAction();
 *   boolean result = pdfAction.openFile( "output.pdf" );
 *   if ( !result ) 
 *   {
 *     // error management
 *   }
 *   pdfAction.setTitle( "Scene Name" );
 *   pdfAction.setText( "Some text describing the exported scene." );
 *   pdfAction.apply( root );
 *   result = pdfAction.closeFile();
 *   if ( !result )
 *   {
 *     // error management
 *   }
 *  \endcode
 * \endif
 *
 * @B Warning @b 
 *  - On some platforms, some third parties may encounter problems to load 
 *    displaying an error message like: "IFXOSFileIterator::ProcessDir: 
 *    error opening /usr/local/u3d/lib/Plugins/ No such file or directory".
 *    In such case, declare the environment variable U3D_LIBDIR (UNIX only) and set it with 
 *    the path to the Open Inventor libraries ($OIVHOME/lib).
 *  - Limitations are common to SoToU3DAction.
 *
 * @SEE_ALSO 
 *    SoToU3DAction.
 *
 */
class HARDCOPY_API SoToPDFAction : public SoToU3DAction
{
  SO_ACTION_HEADER(SoToPDFAction);

public:

  /*
   * Constructor
   */
  SoToPDFAction();

  /*
   * Destructor
   */
  virtual ~SoToPDFAction();

  /**
   * Set the PDF output file. Returns false if an error has occured. 
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE virtual bool openFile(const char* filename);

  /**
   * Set the PDF output file. Returns false if an error has occured. 
   */
  virtual bool openFile( const SbString& filename );

  /**
   * finalize export to the U3D output file. Returns false if an error has occured. 
   */
  virtual bool closeFile();

  /**
   * [Optional] 
   * Set passwords to lock write & read access to the PDF file contents.
   * Passwords are optional.
   * A write password is required before setting a read password.
   * Write and read passwords must be different.
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE void setPassword(const char* writePass, const char* readPass = NULL);

  /**
   * [Optional] 
   * Set passwords to lock write & read access to the PDF file contents.
   * Passwords are optional.
   * A write password is required before setting a read password.
   * Write and read passwords must be different.
   */
  void setPassword( const SbString& writePass, const SbString& readPass = "" );

  /**
   * [Optional] 
   * Set a title into the output PDF file.
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE void setTitle(const char* title);

  /**
   * [Optional] 
   * Set a title into the output PDF file.
   */
  void setTitle(const SbString& title);

  /**
   * [Optional] 
   * Add a text block into the output PDF file.
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE void setText(const char* text);

  /**
   * [Optional] 
   * Add a text block into the output PDF file.
   */
  void setText(const SbString& text);

  /**
   * [Optional] 
   * Changes the page orientation from portrait to landscape.
   */
  void setLandscape( const SbBool enable );

SoINTERNAL public:
  /**
   * Internally used to initialize the class.
   */
  static void initClass();
  static void exitClass();

  static bool writeFile(
    const SbString& pdfOutput, 
    const SbString& writePass, 
    const SbString& readPass, 
    const SbString& title, 
    const SbString& text, 
    const SbString& u3dInput,
    const SbString& u3dView,
    bool hasPerspective,
    float fov,
    float focalDistance,
    bool hasLights,
    const SbColor& background,
    bool landscape = false);

private:

  SoToPDFActionPrivate* m_private;
};

#endif // SO_TO_PDF_ACTION_H


