/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#pragma once

#include <Inventor/sys/port.h>

namespace openinventor
{
  namespace inventor
  {
    /**
    * Miscellaneous definition(s) related to axis.
    *
    * @VSGEXT
    * @ingroup General
    *
    * @DESCRIPTION
    * This defines an axis in the XYZ coordinate axis system.
    *
    * [OIV-WRAPPER-CLASS NO_WRAP]
    */
    class INVENTOR_API Axis
    {

    public:

      /**
       * Specification of either an X, a Y or a Z axis.
       *
       * [OIV-WRAPPER-ENUM STANDALONE,NAME{Axis}]
       */
      enum Type
      {
        /**
         * The X axis
         */
        X,

        /**
         * The Y axis
         */
        Y,

        /**
         * The Z axis
         */
        Z
      };

    private:
      Axis() {};

    };
  }
}
