/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_VIEW_
#define  _PO_VIEW_

#include <Inventor/Gui/view/PoBaseView.h>

/**
 * @VSGEXT  Class to define a view.
 * 
 * @ingroup GuiView
 * 
 * @DESCRIPTION
 *    This class allows the user to define a "view". 
 *
 *   Views allow the application to specify multiple cameras, each with its
 *   own separate viewport (region of the 3D window). This is more powerful
 *   than just using multiple SoCamera nodes, because camera nodes do not
 *   allow specifying a viewport (the viewport is always the full window).
 *
 *   In addition, when mouse event locations are mapped back into 3D space,
 *   Open Inventor automatically uses the view volume of the camera associated
 *   with the view whose viewport currently contains the mouse cursor.
 *
 *   Views can be used to efficiently create the effect of multiple windows,
 *   without the overhead and system dependent code to manage multiple windows.
 *   For example, views can be used to subdivide the window into multiple
 *   independent views of a 3D scene or to create an inset "bird's eye" view 
 *   inside the window.
 *    
 *   Basically, a view consists of a camera (specified with an SoCameraKit) and
 *   a viewport (specified using the fields of this node). The viewport is the 
 *   region of the graphics window in which the scene graph will be rendered.
 *
 *   A To define a view, set the fields #viewportOrigin and #viewportSize to the 
 *   desired viewport position and size in normalized device coordinates [0..1],
 *   then configure the camera (set the part cameraKit). All shape nodes placed 
 *   after this node will be drawn using the specified camera and viewport.
 *   You can define as many views as you want.
 *
 *    @B NOTES: @b
 *    - If you use a viewer, you should call the method 
 *      SoBaseKit::setSearchingChildren(TRUE) to allow the viewer to search
 *      for cameras inside nodekits (like this one).
 *    - Do not place a camera node before this nodekit.
 *    - Create a camera for each view and set it using the setPart method. 
 *      See example in PoSceneView.
 *    - When you use HardCopy, the graphics window is the paper sheet.
 *    - \if_cpp SoGui::init() needs to be called in order to initialize this class
 *      (this is done automatically if you use SoXt, SoWin or SoQt).\endif
 *
 *    @B LIMITATIONS: @b
 *    - The field SoCamera::viewportMapping must be equal to 
 *      ADJUST_CAMERA in order to have a correct vectorisation when you use  
 *      HardCopy,
 *    - Do not use the SoBoxHighlightRenderAction class on a scene graph which contains 
 *      a view,
 *    - Do not push view, 
 *    - Be careful when you use the method viewAll() of the class SoXtViewer, because 
 *      this method works on the entire scene graph and not on a portion of a scene 
 *      graph. Overload this method according to your requirements,
 *    - Some of the viewer functions/buttons do not work correctly with views. @BR
 *      For example, saveHomePosition() and resetToHomePosition() do not work correctly
 *      because the viewer only stores one copy of the camera.
 *    - The viewer rendering options, e.g. wireframe, apply to ALL views inside the
 *      viewer.  You can implement these effects per-view using an SoDrawStyle node
 *      and setOverride() if necessary.
 * 
 * @FILE_FORMAT_DEFAULT
 *    PoView {
 *    @TABLE_FILE_FORMAT
 *       @TR viewportOrigin @TD 0 0
 *       @TR viewportSize @TD 1 1
 *    @TABLE_END
 *    }
 * 
 * @CATALOG_PARTS_INCLUDE poview.cat.html
 */
class INVENTORGUI_API PoView : public PoBaseView 
{
  SO_KIT_HEADER(PoView) ;
  
 public:

  /**
   * Default constructor.
   */
  PoView() ;

  /*----------------------------------------------------------------------------*/

  
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;


 protected:
  // Destructor
  virtual ~PoView() ;

 private:

  virtual SbBool readInstance(SoInput *in, unsigned short flags);
} ;

/*----------------------------------------------------------------------------*/

#endif /* _PO_VIEW_  */


