/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Jun 2007)
**=======================================================================*/

#ifndef  SO_GUI_FULL_VIEWER
#define  SO_GUI_FULL_VIEWER

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoGuiFullViewer
//
// SoXXFullViewer implementation class
// 
//
//////////////////////////////////////////////////////////////////////////////

#include <Inventor/Gui/viewers/SoGuiViewer.h>

// classes used
class SoFieldSensor;
class SoStereoDialog;
class SoAntialiasingParameters;

/** [OIV-WRAPPER-NO-WRAP] */
class INVENTORGUI_API SoGuiFullViewer : public SoGuiViewer 
{
#ifndef HIDDEN_FROM_DOC
  SO_FIELDCONTAINER_HEADER( SoGuiFullViewer );
#endif

SoINTERNAL public:
  // This specifies what should be build by default in the constructor
  enum BuildFlag 
  {
    /**
     *  Doesn't build anything extra 
     */
    BUILD_NONE          = 0x00, 
    /**
     *  Build the decoration only 
     */
    BUILD_DECORATION    = 0x01, 
    /**
     *  Build the popup menu only 
     */
    BUILD_POPUP         = 0x02, 
    /**
     *  Build everything by default 
     */
    BUILD_ALL           = 0xff 
  };

  /*
   * Defines
   */
  // list of the different popup choices
  enum popupChoices 
  {
    VIEW_ALL = 20,  // enables the same menu routine to be used
    SET_HOME,    // as the draw style entrie (can't overlap
    HOME,         // with SoWinViewerDrawStyle values)
    HEADLIGHT, 
    SEEK, 
    PREF, 
    VIEWING, 
    DECORATION, 
    FULLSCREEN,
    COPY_VIEW, 
    PASTE_VIEW,
    HELP
  };

  enum drawChoices 
  {
    AS_IS,
    HIDDEN_LINE, 
    NO_TXT, 
    LOW_RES, 
    LINE, 
    POINT,
    BBOX, 
    
    MOVE_SAME_AS, 
    MOVE_NO_TXT, 
    MOVE_LOW_RES, 
    MOVE_LINE, 
    MOVE_LOW_LINE, 
    MOVE_POINT, 
    MOVE_LOW_POINT, 
    MOVE_BBOX, 
    
    DRAW_STYLE_NUM // specify the length
  };

  // list of the toggle buttons in the popumenu
  enum popupToggles 
  {
    HEADLIGHT_WIDGET = 0,    // very convenient to start at 0
    VIEWING_WIDGET,
    DECORATION_WIDGET,
    FULLSCREEN_WIDGET,
    POPUP_TOGGLE_NUM   // specify the length
  };

  // list of custom push buttons
  enum ViewerPushButtons 
  {
    PICK_PUSH, 
    VIEW_PUSH, 
    HELP_PUSH, 
    HOME_PUSH,
    SET_HOME_PUSH,
    VIEW_ALL_PUSH,
    SEEK_PUSH,
    PUSH_NUM
  };

  /**
   * Constructor.
   */
  SoGuiFullViewer();

  /**
   * Shows/hides the viewer component trim (default on). See the viewer constructor to
   * prevent the decoration from being built.
   *
   * The default value can be set using the environment variable
   * OIV_VIEWER_DECORATION (0 = OFF, 1 = ON).
   */
  void setDecoration( SbBool onOrOff );

  /**
   * Returns whether the viewer component trim is on or off.
   */
  SbBool isDecoration();
    
  /**
   * Enables/disables the viewer popup menu (default enabled). See the viewer
   * constructor to prevent the popup menu from being built.
   *
   * The default value can be set using the environment variable
   * OIV_VIEWER_POPUP_MENU (0 = OFF, 1 = ON).
   *
   * Description or equivalent function for each submenu of this popup menu:
   * - Functions: Manage the position of the camera:
   *   -> Home see resetToHomePosition()
   *   -> Set home see saveHomePosition()
   *   -> View all see viewAll()
   *   -> Seek see seekToPoint(const SbVec2s& mouseLocation)
   * - DrawStyle: Manage the draw style and buffering style:
   *   -> see setDrawStyle(DrawType type, DrawStyle style)
   *   -> see setBufferingType(BufferType type)
   * - Viewing: see setViewing()
   * - Decorations: see setDecoration()
   * - FullScreen: see setFullScreen()
   * - HeadLight: see setHeadlight()
   * - Preferences:
   *   -> Seek to point: Enables/disables seek mode (like the 'S' key)
   *   -> Auto clip planes: Enables/disables automatic clipping
   *   -> Automatic interactive mode: Enables/disables automatic interactive mode
   *   -> Stereo: Opens the stereo dialog
   *   -> Anti-aliasing: see setAntialiasing()
   *   -> Record: Opens the recording dialog
   *   -> Rotation axes: Shows/hides the rotation axes
   */
  void setPopupMenuEnabled( SbBool trueOrFalse );

  /**
   * Returns whether the viewer popup menu is enabled or disabled.
   */
  SbBool isPopupMenuEnabled();

  /**
   * Toggles Antialiasing ON and OFF.
   *
   * This is the method called when clicking the Antialiasing button in the FullViewer GUI.
   * When switching from OFF to ON, the previous antialiasing parameters are
   * correctly restored.
   *
   * @return the state of the antialiasing after the switch.
   */
  bool toggleAntiAliasing();

  // Accessors and mutators for xxWheelVals
  void setRightWheelVal( float newVal );
  float getRightWheelVal() const;

  void setBottomWheelVal( float newVal );
  float getBottomWheelVal() const;

  void setLeftWheelVal( float newVal );
  float getLeftWheelVal() const;

  void initVars( BuildFlag buildFlag ); // Initialize m_popupEnabled & m_decorationFlag

  // ----------------------- Extension usage -----------------------------------
    
  // Subclasses can redefine these to add viewer functionality. They
  // by default call start and finish interactive viewing methods.
  // (defined in the base class).
  virtual void rightWheelStart();
  virtual void bottomWheelStart();
  virtual void leftWheelStart();
  virtual void rightWheelFinish();
  virtual void bottomWheelFinish();
  virtual void leftWheelFinish();

  int SO_WHEEL_DELTA;

  protected:
   /**
    * Destructor.
    */
   virtual ~SoGuiFullViewer();

  // ----------------------- Private usage -------------------------------------
  private:

  SbBool m_decorationFlag;
  SbBool m_popupEnabled;
  float  m_rightWheelVal, m_bottomWheelVal, m_leftWheelVal;

  // Antialiasing parameters to restore after toggling AA OFF with the GUI button
  float m_savedAAQuality;
  SoAntialiasingParameters* m_savedAAParams;
};

#endif  // SO_GUI_FULL_VIEWER


