/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#  include <QEvent>
#  include <QApplication>

#include <Inventor/Qt/OivQtCompat.h>
#include <Inventor/Qt/SoQt.h>

// For compatibility reasons
#define ExtEventApplication SoQtExtEventApplication

/** 
 * QCustomEvent no longer exists in full Qt4 so we have to subclass QEvent
 * to provide our own custom event.
 */
class INVENTORQT_API ExtEvent : public QEvent
{
public:
 /** 
  * Constructor.
  */
  ExtEvent( QEvent::Type type, void* data ) : QEvent( type ), m_data(data) {}; 

 /** 
  * Returns the data sent with the event.
  */
  void* data() { return m_data; }

 /** 
  * Sets the data sent with the event.
  */
  void setData( void* data ) { m_data = data; } 

private:
  void* m_data;
};

/**
 * Overload the QApplication to be able to get devices events like SpaceMouse.
 */
class INVENTORQT_API SoQtExtEventApplication : public QApplication {
public:

  /**
  * Constructor.
  */
  SoQtExtEventApplication( int &argc, char **argv);

  static void allEventFilter( XEvent *event );
};

