#ifndef  _SB_DELEGATE_IMPL_H_
#define  _SB_DELEGATE_IMPL_H_

#include <Inventor/misc/SoRefCounter.h>

/*! \cond PRIVATE */
namespace inventor
{

namespace impl
{

/**
 * Interface SbDelegateImpl
 * Base interface for SbDelegate implementation.
 */
template<typename ReturnType, typename ArgType>
SoINTERNAL class SbDelegateImpl : public SoRefCounter
{
public:
  /** Call function */
  virtual ReturnType call(ArgType arg) const = 0;

  /** Clone this delegate */
  virtual SbDelegateImpl<ReturnType, ArgType>* clone() const = 0;
};

} // impl
} // inventor
/*! \endcond */
#endif // _SB_DELEGATE_IMPL_H_

