/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Mar 2015)
**=======================================================================*/

#ifndef  _SB_DELEGATE_MEMBER_FUN_IMPL_H_
#define  _SB_DELEGATE_MEMBER_FUN_IMPL_H_

#include <Inventor/SbDelegateImpl.h>
#include <Inventor/misc/SoRefCounter.h>
/*! \cond PRIVATE */
namespace inventor
{

namespace impl
{

/**
 * SbDelegatePtrFun
 * Class encapsulating a member function pointer.
 */
template<typename ReturnType, typename ArgType, typename ClassType>
SoINTERNAL class SbDelegateMemberFunImpl : public SbDelegateImpl<ReturnType, ArgType>
{
public:

  typedef  ReturnType (ClassType::*FPTR) (ArgType);

  /**
   * Constructor taking a member function.
   * ex:
   * class MyClass {
   *   int fun(float v) { }
   * };
   * MyClass myClass;
   * SbDelegateMemFun<int, float> delegate(a, &MyClass::fun);
   */
  SbDelegateMemberFunImpl(ClassType& a, FPTR f)
  : m_a(a)
  , m_fMem(f)
  {
  }

  /** Call function with given argument */
  virtual ReturnType call(ArgType arg) const
  {
    return (m_a.*m_fMem)(arg);
  }

  /** Virtual "copy constructor" */
  virtual SbDelegateImpl<ReturnType, ArgType>* clone() const
  {
    return new SbDelegateMemberFunImpl(m_a, m_fMem);
  }

  /**
   * Return true if function encapsulated by this delegate is the given function.
   * An empty delegate is equal to NULL function
   */
  bool equal(ClassType& a, FPTR f) const
  {
    return (&m_a == &a) && (f == m_fMem);
  }

private:

  ClassType& m_a;
  FPTR m_fMem;
};

} // impl
} // inventor
/*! \endcond */
#endif // _SB_DELEGATE_MEMBER_FUN_IMPL_H_

