/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Thibaut Andrieu (Mar 2015)
**=======================================================================*/

#ifndef  _SB_DELEGATE_PTR_FUN_IMPL_H_
#define  _SB_DELEGATE_PTR_FUN_IMPL_H_

#include <Inventor/SbDelegateImpl.h>
#include <Inventor/misc/SoRefCounter.h>

/*! \cond PRIVATE */
namespace inventor
{
namespace impl
{


/**
 * SbDelegatePtrFun
 * Class encapsulating a static function pointer.
 */
template<typename ReturnType, typename ArgType>
SoINTERNAL class SbDelegatePtrFunImpl : public SbDelegateImpl<ReturnType, ArgType>
{
public:

  typedef  ReturnType (*FPTR)(ArgType);

  /** Constructor taking a static function */
  SbDelegatePtrFunImpl(FPTR f)
    : m_fPtr (f)
  {
  }

  /** Call function with given argument */
  virtual ReturnType call(ArgType arg) const { return m_fPtr(arg); }

  /** Virtual "copy constructor" */
  virtual SbDelegateImpl<ReturnType, ArgType>* clone() const
  {
    return new SbDelegatePtrFunImpl(m_fPtr);
  }

  /** Return true if function encapsulated by this delegate is the given function. */
  virtual bool equal(FPTR f) const
  {
    return m_fPtr == f;
  }

private:

  /** Pointer to static function */
  FPTR m_fPtr;
};

} // impl
} // inventor
/*! \endcond */
#endif // _SB_DELEGATE_PTR_FUN_IMPL_H_

