#ifndef SB_MATH_VEC_HELPER_H
#define SB_MATH_VEC_HELPER_H

/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#include <Inventor/SbBase.h>
#include <Inventor/SbVec.h>
#include <Inventor/SbMathHelper.h>


namespace SbMathVecHelper
{

  template< class T>
  class VecTraits
  {
    public:
    typedef float scalarType;
  };

  template< >
  class VecTraits< SbVec3f >
  {
    public:
    typedef float scalarType;
  };

  template< >
  class VecTraits< SbVec3d >
  {
    public:
    typedef  double scalarType;
  };

  /**
  * Coincidence test using given tolerance
  */
  template< class T >
  inline bool isCoinc( const T& x, const T& y,  typename VecTraits<SbVec3f>::scalarType tol = ( typename VecTraits<SbVec3f>::scalarType)SbMathHelper::OIV_DEF_MATH_HELPER_EPS )
  {
    return ( SbMathHelper::isCoinc< typename VecTraits<T>::scalarType>( x[0], y[0], tol ) && 
             SbMathHelper::isCoinc< typename VecTraits<T>::scalarType>( x[1], y[1], tol ) && 
             SbMathHelper::isCoinc< typename VecTraits<T>::scalarType>( x[2], y[2], tol ) );
  }

}
// SB_MATH_VEC_HELPER_H
#endif


