/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SB_SPHERE_
#define _SB_SPHERE_

#include <Inventor/SbVec.h>

class SbLine;
class SbBox3f;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SbSphere
//
//  Represents a sphere in 3D space.
//
//////////////////////////////////////////////////////////////////////////////


/**
* Class for representing a sphere.
*
* @ingroup Basics
*
* @DESCRIPTION
*   Represents a sphere in 3D. This is a lightweight datatype that is used for
*   arguments or return values in the Open Inventor toolkit. See SoSphere for a
*   database sphere (used for rendering, picking, etc.).
*
* @SEE_ALSO
*    SbVec3f,
*    SbLine,
*    SoSphere
*
* [OIVJAVA-WRAPPER-CLASS BASIC_TYPE{true},LAYOUTED_ARRAY_TYPE{float,4}]
*/
class INVENTORBASE_API SbSphere {
public:

  /**
  * Default constructor.  The sphere is not initialized.
  */
  SbSphere()  {}

  /**
  * Constructor that takes a center and a radius.
  */
  SbSphere(const SbVec3f &c, float r);

  /**
  * Change the center and radius.
  */
  void   setValue(const SbVec3f &c, float r);

  /**
  * Set the center.
  */
  void  setCenter(const SbVec3f &c);
  /**
  * Set the radius.
  */
  void  setRadius(float r);

  /**
  * Return the center.
  */
  const SbVec3f &getCenter() const    { return center; }
  /**
  * Return the radius.
  */
  float    getRadius() const    { return radius; }

  /**
  * Return a sphere containing a given box.
  */
  void  circumscribe(const SbBox3f &box);

  /**
  * Intersect line and sphere, returning TRUE if there is an intersection. The line
  * is treated as a ray.
  * [OIVJAVA-WRAPPER NAME{intersectFirst}]
  */
  SbBool  intersect(const SbLine &l, SbVec3f &intersection) const;
  /**
  * Intersect line and sphere, returning TRUE if there is an intersection. The line
  * is treated as a ray.
  */
  SbBool  intersect(const SbLine &l, SbVec3f &enter, SbVec3f &exit) const;

private:
  SbVec3f  center;
  float  radius;

};

#endif /* _SB_SPHERE_ */


