/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Oct 2006)
**=======================================================================*/


#ifndef _SB_VEC2STRING_
#define _SB_VEC2STRING_

#include <Inventor/SbString.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SbVec2String
//
//  2D vector used to store two SbStrings.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * 2D SbString vector class.
 * 
 * @ingroup Basics
 * 
 * @DESCRIPTION
 *   2D SbString vector class used to store two SbStrings. This class is used
 *   throughout Open Inventor for arguments and return values.
 * 
 * @SEE_ALSO
 *    SbString
 * 
 * 
 * [OIV-WRAPPER-NO-WRAP]
 */
class INVENTORBASE_API SbVec2String {
 public:

  /**
   * Default constructor.  The value is not initialized.
   */
  SbVec2String()    { }

  /**
   * Constructor given vector components.
   */
  SbVec2String(const SbString v[2])    { vec[0]=v[0]; vec[1]=v[1]; }

  /**
   * Constructor given two SbStrings.
   */
  SbVec2String(SbString x, SbString y)    { vec[0]=x; vec[1]=y; }

  /**
   * Returns vector components.
   */
  const SbString  *getValue() const  { return vec; }

  /**
   * Returns vector components.
   */
  void  getValue(SbString &x, SbString &y) const;

  /**
   * Sets the vector components.
   */
  SbVec2String &setValue(const SbString v[2]);

  /**
   * Sets the vector components.
   */
  SbVec2String &setValue(SbString x, SbString y);

  //@{
  /**
   * Accesses indexed component of vector.
   */
  SbString & operator [](int i) { return (vec[i]); }
  const SbString & operator [](int i) const   { return (vec[i]); }
  //@}

  /**
   * Equality comparison operator.
   */
  INVENTORBASE_API friend int operator ==(const SbVec2String &v1, const SbVec2String &v2);

  /**
   * Inequality comparison operator.
   */
  INVENTORBASE_API friend int operator !=(const SbVec2String &v1, const SbVec2String &v2)
  { return !(v1 == v2); }

 protected:
  SbString  vec[2];    // Storage for SbString vector components

};

#endif /* _SB_VEC2STRING_ */

