/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jean-Paul Digeon (MMM yyyy)
**=======================================================================*/

#ifndef _SO_INPUTPARAMETERS_
#define _SO_INPUTPARAMETERS_

#include <Inventor/sys/port.h>



#if defined(_WIN32)
#pragma warning( push )
#pragma warning( disable: 4251 ) // 'identifier' : class 'type' needs to have dll-interface to be used by clients of class 'type2'
#endif



/**
 * @VSGEXT Base class for file reader parameters. 
 *
 * @ingroup General
 *
 * @DESCRIPTION
 *
 * SoInputParameters is a base class and needs to be specialized to be effective.
 * The goal of SoInputParameters is to provide a way to control/modify processing
 * of a file during the read.
 * Each implementation of SoInputParameters is free to publish parameters 
 * (for example the desired tesselation level if you are reading a CAD file) or to
 * notify during the read of the file using an abstract method implemented by the
 * application.
 *
 * This class is used with the SoInput::setInputParameters() method.
 *
 * @SEE_ALSO
 *    SoInput
 */
class INVENTOR_API SoInputParameters
{
 public:
   SoInputParameters();
   virtual ~SoInputParameters();

  
};

#if defined(_WIN32)
#pragma warning( pop )
#endif

#endif /* _SO_INPUTPARAMETERS_ */

