/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Created by : VSG (mar 2012)
**=======================================================================*/

#ifndef  _SO_INPUT_READER_H_
#define  _SO_INPUT_READER_H_

#include <Inventor/misc/SoRefCounter.h>
#include <Inventor/SoTypedObject.h>
#include <Inventor/SoSubTypedClass.h>

class SoSeparator;
class SoInput;

/**
 * Base class for custom readers that create an Open Inventor scene graph
 *
 * @ingroup Plugins
 *
 * @DESCRIPTION
 *
 *  This class defines the base interface for loading a scene graph from an
 *  data format that is not directly supported by Open Inventor.
 *
 *  Input readers should be loaded and managed as plugins.
 *  Open Inventor automtically attempts to load all files that may be
 *  plugin libraries (files with the extension .dll or .so depending on the platform).
 *  Plugin libraries may also be explicitly loaded using SoDB::addPlugin().  See more
 *  details on that page. The file name convention (not required) for readers
 *  is "Iv*Reader.dll (or .so)".
 *
 *  A plugin library must implement the initPlugin() and exitPlugin() C-formatted entry-points.
 *  The initPlugin() function is responsible for registering the new class (or classes)
 *  in the Open Inventor database through the standard SoType type creation mechanism.
 *  The exitPlugin() function is used to disable the use of the custom class(s)
 *  by removing the corresponding type(s) from the Open Inventor database.
 *
 *  When SoDB::readAll() (for example) is called to create a scene graph from a
 *  file or buffer, Open Inventor first attempts to handle the data as .iv
 *  format.  If that fails, Open Inventor will call the canConvert() method for
 *  each loaded plugin class, that is derived from SoInputReader, in the order they
 *  were loaded.  The first reader plugin that returns true from this method will be
 *  used to handle the data.
 *
 * @SEE_ALSO
 *    SoInput,
 *    SoDB::addPlugin()
 *    SoDB::removePlugin()
 *    SoDB::getPlugins()
 *    SoDB::addPluginsDirectory()
 *    SoDB::removePluginsDirectory()
 *    SoDB::getPluginsDirectories()
 *
 */
class INVENTOR_API SoInputReader : public SoRefCounter, public SoTypedObject
{
  SO_TYPED_CLASS_ABSTRACT_HEADER();

public:

  /**
   * Returns true if the specified input source can be converted by this plugin.
   *
   * Note that the input source (SoInput object) may be a file or a buffer (memory).
   * This method should return false if the input source is a buffer
   * and the reader does not support reading from a buffer. SoInput::getCurFile()
   * returns NULL if the input source is a buffer.
  */
  virtual bool canConvert( SoInput* in ) = 0;

  /**
   * Returns the specified input source in the form of an Open Inventor scene graph.
   *
   * Note that the input source (SoInput object) may be a file or a buffer (memory).
   * This method should return NULL if the input source is a buffer
   * and the reader does not support reading from a buffer. SoInput::getCurFile()
   * returns NULL if the input source is a buffer.
   */
  virtual SoSeparator* convert( SoInput* ) = 0;

protected:
  SoInputReader();
  virtual ~SoInputReader();
};

#endif // _SO_INPUT_READER_H_

