/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : David Mott (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_INTERACTION_
#define  _SO_INTERACTION_

#include <Inventor/SbBasic.h>

/**
 * Initializes Open Inventor interaction classes.
 * 
 * @ingroup General
 * 
 * @DESCRIPTION
 *   SoInteraction has static functions which initialize all Open Inventor
 *   interaction classes, as well as nodekits and the database. 
 *   
 *   Note that SoInteraction::init() is called by SoWin/Xt/Qt::init().
 * 
 * @SEE_ALSO
 *    SoDB,
 *    SoNodeKit,
 *    SoWin
 * 
 *
 * [OIV-WRAPPER-NO-WRAP]
 */
class INVENTOR_API SoInteraction {
 public:
  /**
   * Initializes all interaction classes with single thread support.
   * 
   * It calls SoDB::init() and SoNodeKit::init(), calls
   * initClasses() on SoDragger, and calls initClass() on the following
   * classes: SoAntiSquish, SoBoxHighlightRenderAction, SoCenterballManip,
   * SoDirectionalLightManip, SoExtSelection, SoHandleBoxManip, SoInteractionKit, SoJackManip,
   * SoLineHighlightRenderAction, SoPointLightManip, SoSelection, SoSpotLightManip,
   * SoSurroundScale, SoTabBoxManip, SoTrackballManip, SoTransformBoxManip, and
   * SoTransformManip. 
   */
  static void init();

  /** 
   * Frees Open Inventor's internal static memory 
   * allocations. This avoids false positives from memory
   * leak checking software. We recommend calling this method
   * and it should be the last Open Inventor method called by
   * the application.
   */
  static void finish();

#if SoDEPRECATED_BEGIN(10000)

  SoDEPRECATED_METHOD(10000, "Use SoInteraction::init() instead.")
  static void threadInit();   // init all interaction classes with MT support

  SoDEPRECATED_METHOD(10000, "Use SoInteraction::finish() instead.")
  static void threadFinish();   // init all interaction classes with MT support
#endif /** @DEPRECATED_END */

  static bool isInitialized();

 private:
  
  static void internalInit();

  static void internalFinish();

  // has interaction been initialized
  static int s_initRefCount;
};

#endif /* _SO_INTERACTION_ */

