/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef SO_TYPED_CLASS_
#define SO_TYPED_CLASS_

#include <Inventor/SoType.h>


#define SO_TYPED_CLASS_INTERNAL_HEADER()                        \
public:                                                         \
  SoType getTypeId() const;                                     \
  static SoType getClassTypeId();                               \
  static void *createFromSoType(SoType* dynamicType = NULL);    \
private:                                                        \
  static SoType   m_classTypeId;                                \
  static SbBool   m_isFirstTime

#define SO_TYPED_CLASS_HEADER()                                 \
  SO_TYPED_CLASS_INTERNAL_HEADER();                             \
public:                                                         \
  static void initClass();                                      \
  static void exitClass()

#define SO_TYPED_CLASS_ABSTRACT_VARS(className)                  \
    SoType className::m_classTypeId;                              \
    SbBool className::m_isFirstTime = TRUE;
//
// Non-abstract nodes have all the stuff abstract nodes do
//
#define SO_TYPED_CLASS_VARS(className) \
    SO_TYPED_CLASS_ABSTRACT_VARS(className)

#define SO_TYPED_CLASS_INTERNAL_SOURCE(parent, className, classPrintName)        \
                                                                        \
  SO_TYPED_CLASS_ABSTRACT_VARS(className)                                \
                                                                        \
  SoType                                                                \
  className::getTypeId() const                                          \
  {                                                                     \
    return m_classTypeId;                                               \
  }                                                                     \
                                                                        \
  SoType                                                                \
  className::getClassTypeId()                                           \
  {                                                                     \
    return m_classTypeId;                                               \
  }                                                                     \
                                                                        \
  void *                                                                \
  className::createFromSoType(SoType*)                                    \
  {                                                                     \
    return (void *)(new className);                                     \
  }

#define SO_TYPED_CLASS_SOURCE(parentClass, className, classPrintName)        \
  SO_TYPED_CLASS_INTERNAL_SOURCE(parentClass,className,classPrintName)       \
                                                                        \
  void                                                                  \
  className::initClass()                                                \
  {                                                                     \
    SO_TYPED_CLASS_INIT_CLASS(className,classPrintName,parentClass)     \
  }                                                                     \
                                                                        \
  void                                                                  \
  className::exitClass()                                                \
  {                                                                     \
    SO_TYPED_CLASS_EXIT_CLASS(className)                 \
  }

#define SO_TYPED_CLASS_ABSTRACT_INTERNAL_SOURCE(className)              \
  SO_TYPED_CLASS_ABSTRACT_VARS(className)

#define SO_TYPED_CLASS_ABSTRACT_SOURCE(className, classPrintName, parentClass)       \
  SO_TYPED_CLASS_ABSTRACT_INTERNAL_SOURCE(className)                    \
  void                                                                  \
  className::initClass()                                                \
  {                                                                     \
    SO_TYPED_CLASS_INIT_ABSTRACT_CLASS(className, classPrintName, parentClass)       \
  }                                                                     \
                                                                        \
  void                                                                  \
  className::exitClass()                                                \
  {                                                                     \
    SO_TYPED_CLASS_EXIT_ABSTRACT_CLASS(className)        \
  }

#define SO_TYPED_CLASS_ABSTRACT_INTERNAL_HEADER()               \
public:                                                         \
  virtual SoType getTypeId() const = 0;                         \
  static SoType getClassTypeId() { return m_classTypeId; }      \
                                                                \
private:                                                        \
  static SoType   m_classTypeId;                                \
  static SbBool   m_isFirstTime
  
#define SO_TYPED_CLASS_ABSTRACT_HEADER()                        \
  SO_TYPED_CLASS_ABSTRACT_INTERNAL_HEADER();                    \
public:                                                         \
  static void initClass();                                      \
  static void exitClass();

#define SO_TYPED_CLASS_INIT_ABSTRACT_CLASS(className,classPrintName,parentClass) \
  if (m_isFirstTime)                                                  \
  {                                                                   \
    if (parentClass::getClassTypeId() == SoType::badType() )               \
      parentClass::initClass();                                            \
    m_classTypeId = SoType::createType(parentClass::getClassTypeId(),      \
                                        classPrintName,                \
                                        NULL);   \
    m_isFirstTime = FALSE;                                            \
  }

#define SO_TYPED_CLASS_EXIT_ABSTRACT_CLASS(className) \
  SoType::removeType(m_classTypeId.getName());  \
  m_classTypeId = SoType::badType();  \
  m_isFirstTime = TRUE;

#define SO_TYPED_CLASS_INIT_CLASS(className,classPrintName,parentClass) \
  if (m_isFirstTime)                                                  \
  {                                                                   \
    if (parentClass::getClassTypeId() == SoType::badType() )               \
      parentClass::initClass();                                            \
    m_classTypeId = SoType::createType(parentClass::getClassTypeId(),      \
                                        classPrintName,                \
                                        &className::createFromSoType);   \
    m_isFirstTime = FALSE;                                            \
  }

#define SO_TYPED_CLASS_EXIT_CLASS(className) \
  SO_TYPED_CLASS_EXIT_ABSTRACT_CLASS(className)

#endif


