/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#ifndef WINTIMER_H
#define WINTIMER_H

#include <Inventor/sensors/SoSensor.h>
#include <Inventor/sensors/SoSystemTimer.h>
#include <Inventor/misc/SoRef.h>
#include <windows.h>

/**
 * Class to integrate Windows timer into OpenInventor
 *
 * @ingroup ViewerComponentsMFC
 */
class MFCVIEWERCOMPONENTS_API WinTimer : public SoSystemTimer
{

public:

  /**
   * Constructor
   */
  WinTimer();

  /**
   *  Start the timer
   */
  virtual void start();

  /**
   * Stop the timer
   */
  virtual void stop();

  /**
   * Set the delay of the timer
   */
  virtual void setDelay(int time);

  /**
   * Return true if the timer is pending
   */
  virtual bool isPending() const;

  /**
   * Set if the timer is in the repeat mode
   */
  virtual void setRepeat(bool flag);

  /**
   * Set task associated to the timer
   */
  virtual void setTask(SoSystemTimerTask* task);

  /**
   * This function is call when the timer timeout
   */
  void timeOut();

private:

  SoRef<SoSystemTimerTask> m_task;  
  int m_delay;
  bool m_singleShot;
  bool m_started;
  HANDLE m_timer;
};

#endif //WINTIMER_H
