#pragma once

#include "QtEventToSoEvent.h"

/**
 * @ingroup ViewerComponentsQt
 */
class SoDEPRECATED_CLASS(101000, "No longer supported, use #QtEventToSoEvent instead") QTVIEWERCOMPONENTS_API QEventToSoEvent : public QtEventToSoEvent
{
public:

  /**
   * Transform QMousePressEvent to SoMouseButtonEvent
   * @param qevent Qt event to transform
   * @param widget QWidget where the event is firered
   */
  static SoMouseButtonEvent*
  getMousePressEvent( QMouseEvent* qevent, QWidget* widget )
  {
    return QtEventToSoEvent::getMousePressEvent( qevent, QPoint( qevent->x() * widget->devicePixelRatio(),
                                                                ( ( widget->height() - 1 ) - qevent->y() ) * widget->devicePixelRatio() ) );
  }

  /**
   * Transform QMouseReleaseEvent to SoMouseButtonEvent
   * @param qevent Qt event to transform
   * @param widget QWidget where the event is firered
   */
  static SoMouseButtonEvent*
  getMouseReleaseEvent( QMouseEvent* qevent, QWidget* widget )
  {
    return QtEventToSoEvent::getMouseReleaseEvent( qevent, QPoint( qevent->x() * widget->devicePixelRatio(),
                                                                   ( ( widget->height() - 1 ) - qevent->y() ) * widget->devicePixelRatio() ) );
  }

  /**
   * Transform QMouseDoubleClickEvent to SoMouseButtonEvent
   * @param qevent Qt event to transform
   * @param widget QWidget where the event is firered
   */
  static SoMouseButtonEvent*
  getMouseDoubleClickEvent( QMouseEvent* qevent, QWidget* widget )
  {
    return QtEventToSoEvent::getMouseDoubleClickEvent( qevent, QPoint( qevent->x() * widget->devicePixelRatio(),
                                                                       ( ( widget->height() - 1 ) - qevent->y() ) * widget->devicePixelRatio() ) );
  }

  /**
   * Transform QMouseWheelEvent to SoMouseButtonEvent
   * @param qevent Qt event to transform
   */
  static SoMouseWheelEvent*
  getMouseWheelEvent( QWheelEvent* qevent, QWidget* )
  {
    return QtEventToSoEvent::getMouseWheelEvent( qevent );
  }

  /**
   * Transform QMouseMoveEvent to SoMouseButtonEvent
   * @param qevent Qt event to transform
   * @param widget QWidget where the event is firered
   */
  static SoLocation2Event*
  getMouseMoveEvent( QMouseEvent* qevent, QWidget* widget )
  {
    return QtEventToSoEvent::getMouseMoveEvent( qevent, QPoint( qevent->x() * widget->devicePixelRatio(),
                                                                ( ( widget->height() - 1 ) - qevent->y() ) * widget->devicePixelRatio() ) );
  }

  /**
   * Transform QMouseEnterEvent to SoMouseButtonEvent
   */
  static SoLocation2Event*
  getMouseEnterEvent( QEvent*, QWidget* )
  {
    return QtEventToSoEvent::getMouseEnterEvent();
  }

  /**
   * Transform QMouseLeaveEvent to SoMouseButtonEvent
   */
  static SoLocation2Event*
  getMouseLeaveEvent( QEvent*, QWidget* )
  {
    return QtEventToSoEvent::getMouseLeaveEvent();
  }

  /**
   * Transform QKeyEvent press to SoKeyboardEvent
   * @param qevent Qt event to transform
   */
  static SoKeyboardEvent*
  getKeyPressEvent( QKeyEvent* qevent )
  {
    return QtEventToSoEvent::getKeyPressEvent( qevent );
  }

  /**
   * Transform QKeyEvent release to SoKeyboardEvent
   * @param qevent Qt event to transform
   */
  static SoKeyboardEvent*
  getKeyReleaseEvent( QKeyEvent* qevent )
  {
    return QtEventToSoEvent::getKeyReleaseEvent( qevent );
  }

  /**
   * Transform QTouchEvent to a list of SoEvent representing the touch event
   * @param qevent Qt event to transform
   * @param widget QWidget where the event is firered
   */
  const std::vector<const SoEvent*>&
  getTouchEvents( QTouchEvent* qevent, QWidget* widget )
  {
    return QtEventToSoEvent::getTouchEvents( qevent, widget->height() );
  }
};
