#pragma once

#include <Inventor/ViewerComponents/Qt/QML/RenderAreaInteractive.h>
#include <Inventor/ViewerComponents/nodes/SceneOrbiter.h>

namespace openinventor {
namespace inventor {
namespace viewercomponents {
namespace qt {
namespace qml {

/**
 * @PREVIEWTAG
 *
 * Class to render an OpenInventor scene in a QML item.
 * This class extends RenderAreaInteractive to add scene orbiter viewer behaviors.
 * Unlike the RenderAreaExaminer, the scene orbiter is a "mode-less" viewer.
 *
 * Note: When using this component, the automatic interactive mode is disabled,
 * see SoSceneManager::setAutoInteractiveMode for more details.
 * Interactive mode is managed by the SceneOrbiter node.
 *
 * @SEE_ALSO
 *    SceneOrbiter
 *
 * @ingroup ViewerComponentsQt
 *
 * @SEE_ALSO
 * RenderArea, RenderAreaInteractive
 *
 * @PREVIEWFEATURES
 */
class QTVIEWERCOMPONENTS_API RenderAreaOrbiter : public RenderAreaInteractive
{
public:

  RenderAreaOrbiter();

  /**
   * Returns the scene orbiter.
   */
  virtual SceneOrbiter* getSceneInteractor() const;

protected:

  void createRenderAreaCore( SbVec2i32 region ) override;

private:
  SceneOrbiter* m_sceneOrbiter;
};

} // namespace qml
} // namespace qt
} // namespace viewercomponents
} // namespace inventor
} // namespace openinventor
