/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#ifndef SI_RENDERAREA_STILL_SUPERSAMPLING
#define SI_RENDERAREA_STILL_SUPERSAMPLING

#include <Inventor/sys/port.h>

/**
* @VSGEXT RenderArea still supersampling interface.
*
* @ingroup ViewerComponents
*
* @DESCRIPTION
*
* This interface provides the list of methods that renderAreas must define to use still supersampling feature.
*
* @SEE_ALSO
*  SoRenderAreaCore
*
*/
class INVENTOR_API SiRenderAreaStillSuperSampling
{

public:

  /**
   * Set quality for supersampling when "still" (not interacting).
   * When quality is greater than 0, still images will be automatically supersampled.
   */
  virtual void setStillSuperSamplingQuality(float quality) = 0;

  /**
   * @see setStillSuperSamplingQuality().
   */
  virtual float getStillSuperSamplingQuality() const = 0;

  /**
   * Set delay for supersampling when "still" (not interacting).
   * If greater than 0, images will be supersampled after the specified delay.
   * The delay is in milliseconds.
   */
  virtual void setStillSuperSamplingDelay(unsigned int delay) = 0;

  /**
   * @see setStillSuperSamplingDelay().
   */
  virtual unsigned int getStillSuperSamplingDelay() const = 0;

};

#endif // SI_RENDERAREA_STILL_SUPERSAMPLING
