/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/

#ifndef SI_RENDERAREA_TRANSPARENCY
#define SI_RENDERAREA_TRANSPARENCY

#include <Inventor/actions/SoGLRenderAction.h>

/**
* @VSGEXT RenderArea transparency interface.
*
* @ingroup ViewerComponents
*
* @DESCRIPTION
*
* This interface provides the list of methods that renderAreas must define to use transparency feature.
*
* @SEE_ALSO
*  SoRenderAreaCore
*
*/
class INVENTOR_API SiRenderAreaTransparency
{

public:

  /**
   * Sets global transparency algorithm to use when rendering.
   */
  virtual void setTransparencyType( SoGLRenderAction::TransparencyType type ) = 0;

  /**
   * @see setTransparencyType().
   */
  virtual SoGLRenderAction::TransparencyType getTransparencyType() const = 0;

};

#endif // SI_RENDERAREA_TRANSPARENCY
