/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#ifndef WinEventToSoEvent_h
#define WinEventToSoEvent_h

#include <Inventor/ViewerComponents/SoEventBuilder.h>
#include <Inventor/Events/SoMouseButtonEvent.h>

class RenderArea;

/**
 * @ingroup ViewerComponentsWin
 */
class WINVIEWERCOMPONENTS_API WinEventToSoEvent
{

public:

  /**
   * Transform a Win mouse press event to a SoMouseButtonEvent
   */
  static SoMouseButtonEvent* getMousePressEvent( LPARAM loc, SoMouseButtonEvent::Button button, RenderArea* renderArea );

  /**
   * Transform a Win mouse release event to a SoMouseButtonEvent
   */
  static SoMouseButtonEvent* getMouseReleaseEvent( LPARAM loc, SoMouseButtonEvent::Button button, RenderArea* renderArea );

  /**
   * Transform a Win mouse double click event to a SoMouseButtonEvent
   */
  static SoMouseButtonEvent* getMouseDoubleClickEvent( LPARAM loc, SoMouseButtonEvent::Button button, RenderArea* renderArea );

  /**
   * Transform a Win mouse move event to a SoLocation2Event
   */
  static SoLocation2Event* getMouseMoveEvent( LPARAM loc, RenderArea* renderArea );

  /**
   * Transform a Win mouse wheel event to a SoMouseWheelEvent
   */
  static SoMouseWheelEvent* getMouseWheelEvent( short zDelta, RenderArea* );

  /**
   * Transform a Win mouse enter in the window event to a SoLocation2Event
   */
  static SoLocation2Event* getMouseEnterEvent( RenderArea* );

  /**
   * Transform a Win mouse leave the window event to a SoLocation2Event
   */
  static SoLocation2Event* getMouseLeaveEvent( RenderArea* );

  /**
   * Transform a Win key press event to a SoKeyboardEvent
   */
  static SoKeyboardEvent* getKeyPressEvent( WPARAM param, RenderArea* );

  /**
   * Transform a Win key release event to a SoKeyboardEvent
   */
  static SoKeyboardEvent* getKeyReleaseEvent( WPARAM param, RenderArea* );

  /**
   * Transform  Win touch events to a vector of SoEvent
   */
  static void getTouchEvents( WPARAM wParam, LPARAM lParam, RenderArea*, std::vector<const SoEvent*>& eventsList );

private:
  static bool initClass();
  static bool s_init;

  static SoKeyboardEvent::Key getIvKey( WPARAM param );
  static SoEventBuilder m_ivEvent;
  static std::map<DWORD, unsigned int> m_touchIDMap;

  static SoKeyboardEvent::Key keyMap[256];
  static int keyMapInitFlag;

  static bool m_ctrlModifier;
  static bool m_altModifier;
  static bool m_shiftModifier;

  static SbVec2s getMousePosition( LPARAM loc );
};

#endif // WinEventToSoEvent
