/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/





#ifndef _SO_WIN_LIGHT_SLIDER_SET_
#define _SO_WIN_LIGHT_SLIDER_SET_

#include <Inventor/Win/SoWinBeginStrict.h>
#include <Inventor/Win/SoWinSliderSet.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoWinLightSliderSet
//
//  For editing light source nodes.
//
//  The SoWinLightSliderSet allocates:
//     1 SoWinLightIntensitySliderModule   (for editing light intensity)
//     1 SoWinLightColorSliderModule       (for editing light color)
//
//////////////////////////////////////////////////////////////////////////////

SoINTERNAL class INVENTORW_API SoWinLightSliderSet : public SoWinSliderSet {
 public:
  SoWinLightSliderSet( 
                      SoWidget parent = NULL,
                      const char *name = NULL, 
                      SbBool buildInsideParent = TRUE,
                      SoNode *newEditNode = NULL );
  ~SoWinLightSliderSet();
    
 protected:

  // This constructor takes a boolean whether to build the widget now.
  // Subclasses can pass FALSE, then call the buildWidget() method on
  // this class when they are ready for it to be built.
  SoEXTENDER
    SoWinLightSliderSet(
                        SoWidget parent,
                        const char *name, 
                        SbBool buildInsideParent, 
                        SoNode *newEditNode,
                        SbBool buildNow);
    
  SoWidget      buildWidget(SoWidget parent);
  
  // this is called by both constructors
  void constructorCommon(SbBool buildNow);
};

#include <Inventor/Win/SoWinEndStrict.h>

#endif /* _SO_WIN_LIGHT_SLIDER_SET_ */


