/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/



#ifndef  _SO_WIN_KEYBOARD_
#define  _SO_WIN_KEYBOARD_

#include <Inventor/Win/SoWinBeginStrict.h>
#include <windows.h>

#include <Inventor/Win/devices/SoWinDevice.h>
#include <Inventor/events/SoKeyboardEvent.h>

#define SO_WIN_ALL_KEYBOARD_EVENTS (KeyPressMask | KeyReleaseMask)

/**
 * @VSGEXT Translates and reports messages for the keyboard device.
 * 
 * @ingroup Win
 * 
 * @DESCRIPTION
 *   This class translates and manages messages generated by the keyboard, 
 *   including key press and release messages (SoKeyboardEvent).
 * 
 * @SEE_ALSO
 *    SoWinDevice,
 *    SoKeyboardEvent
 */
class INVENTORW_API SoWinKeyboard : public SoWinDevice {
 public:
  /**
   * Constructor. To the constructor, pass which keyboard messages you
   * are interested in as a bitwise OR of the following values:
   * 
   * KeyPressMask - Key press messages
   * 
   * KeyReleaseMask - Key release messages
   * 
   * Or simply pass the defined value SO_WIN_ALL_KEYBOARD_EVENTS for all keyboard
   * messages. The device will only report messages of this type for the window
   * handle it is enabled on.
   */
  SoWinKeyboard(EventMask mask = SO_WIN_ALL_KEYBOARD_EVENTS);
  /**
   * Destructor. 
   */
  ~SoWinKeyboard();
    
  /** @copydoc SoWinDevice::enable() */
  virtual void        enable(SoWidget w, XtEventHandler f,
                             XtPointer data, Window win = NULL);

  /** @copydoc SoWinDevice::disable() */
  virtual void        disable(SoWidget w, XtEventHandler f, XtPointer data);
    
  /** @copydoc SoWinDevice::translateEvent() */
  virtual const SoEvent * translateEvent(XAnyEvent *xevent);
  
 private:
  EventMask           eventMask;      // X event interest for this device
  SoKeyboardEvent     *keyEvent;      // keyboard press or release

  bool setKey(XKeyEvent *ke); // Return true if a WM_CHAR will be send by windows API
  void setUnicodeKey(XKeyEvent *ke);
  SoKeyboardEvent* translateKeyEvent(XKeyEvent *ke, SoButtonEvent::State s);

  // Mapping from _WIN32 virtual keys to SoKeyboardEvent::Key enum
  static SoKeyboardEvent::Key keyMap[256];
  static int keyMapInitFlag;
};

#include <Inventor/Win/SoWinEndStrict.h>

#endif /* _SO_WIN_KEYBOARD_ */

