/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/



#ifndef  _SO_WIN_SPACEBALL_
#define  _SO_WIN_SPACEBALL_

#include <Inventor/Win/SoWinBeginStrict.h>

#include <windows.h>
#include <Inventor/Win/SoWin.h>
#include <Inventor/Win/devices/SoWinDevice.h>

#include <Inventor/events/SoMotion3Event.h>
#include <Inventor/events/SoSpaceballButtonEvent.h>
#include <Inventor/Win/SoWinRenderArea.h>

#include <Inventor/Gui/devices/SoGuiSpaceball.h>
/**
 * @VSGEXT Translates and reports events for a SpaceBall or SpaceMouse (Magellan) device.
 * 
 * @ingroup Win
 * 
 * @DESCRIPTION
 *   This class manages events generated by the spaceball, including spaceball motion
 *   (SoMotion3Event), and spaceball button press and release events
 *   (SoSpaceballButtonEvent).
 * 
 * @SEE_ALSO
 *    SoWinDevice,
 *    SoMotion3Event,
 *    SoSpaceballButtonEvent
 */
class INVENTORW_API SoWinSpaceball : public SoWinDevice {

 public:

  //
  // valid event mask values:
  //        SoWinSpaceball::MOTION   - spaceball translation and rotation
  //        SoWinSpaceball::PRESS    - spaceball button press
  //        SoWinSpaceball::RELEASE  - spaceball button release
  //        SoWinSpaceball::ALL     - all spaceball events
  // Bitwise OR these to specify whichEvents this device should queue.
  //
  
  /**
   * Used in glxWindowProc method from SoWinGLWidget and SoWinMPGLWidget.
   * [OIV-WRAPPER-NOT-WRAP]
   */
  static SbBool isSpaceMousePresent();
  
  /**
   * Constructor.
   */
  SoWinSpaceball(SoGuiSpaceball::Mask mask = SoGuiSpaceball::ALL);

  /**
   * Destructor.
   */
  ~SoWinSpaceball();
  
  /** @copydoc SoWinDevice::enable() */
  virtual void enable(SoWidget w, XtEventHandler f,
                      XtPointer data, Window win = NULL);

  /** @copydoc SoWinDevice::disable() */
  virtual void disable(SoWidget w, XtEventHandler f, XtPointer data);
  
  /** @copydoc SoWinDevice::translateEvent() */
  virtual const SoEvent *translateEvent(XAnyEvent *xevent);
  
  /**
   * The spaceball reports rotations and translations as integers. These values must
   * be scaled to be useful. This method sets the rotation scale factor. 
   * Default is .006.
   */
  void setRotationScaleFactor(float f) { m_guiSpaceball->setRotationScaleFactor( f ); }

  /**
   * Returns the rotation scale factor.
   */
  float getRotationScaleFactor() const { return m_guiSpaceball->getRotationScaleFactor(); }

  /**
   * The spaceball reports rotations and translations as integers. These values must
   * be scaled to be useful. This method sets the translation the scale factor. Default
   * is .006.
   */
  void setTranslationScaleFactor(float f) { m_guiSpaceball->setTranslationScaleFactor( f ); }

  /**
   * Returns the translation scale factor.
   */
  float getTranslationScaleFactor() const { return m_guiSpaceball->getTranslationScaleFactor(); }
  
  /**
   * Returns whether or not the spaceball device exists for use.
   */
  static SbBool exists();
  
  /**
   * Win32 does not support focus change. This method is provided for source
   * compatibility.
   */
  void setFocusToWindow(SbBool flag) { m_guiSpaceball->setFocusToWindow( flag ); }

  /**
   * Win32 does not support focus change. This method is provided for source
   * compatibility.
   */
  SbBool isFocusToWindow() const { return m_guiSpaceball->isFocusToWindow(); }

 private:

   SoGuiSpaceball* m_guiSpaceball; // Implementation class for SoXxSpaceball

  SoMotion3Event *motionEvent; // spaceball rotation/translation
  SoSpaceballButtonEvent *buttonEvent; // spball button press/release
  
  // The first widget which registered the space ball object
  SoWidget parentWidget;

  HWND m_curHwnd;

  // event translators!
  SoMotion3Event *translateMotionEvent(MSG *me);
  SoSpaceballButtonEvent *translateButtonEvent(MSG *be,
                                               SoButtonEvent::State whichState);
  SoMotion3Event *translateMotionEventMagellan(MSG *me);
  
  // Magellanstruct _MagellanControl_ Space Mouse data structure 
  struct _MagellanControl_ *magellanHandle;
};

#include <Inventor/Win/SoWinEndStrict.h>

#endif /* _SO_WIN_SPACEBALL_ */

