/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Nick Thompson (MMM yyyy)
** Modified by : Paul Isaacs (MMM yyyy)
** Modified by : David Mott (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifdef SOQT
#  include <Inventor/Qt/SoQt.h>
#elif defined(_WIN32)
#  include <Inventor/Win/SoXt2SoWin.h>
#  include <Inventor/Win/SoWin.h>
#else

#ifndef _SO_XT_
#define _SO_XT_

#include <SbTypes.h>
#include <Xm/Xm.h>
#include <Inventor/SbBasic.h>
#include <Inventor/SbLinear.h>
#include <Inventor/Xt/SoXtDef.h>
#include <Inventor/Xt/SoXtLocalisation.h>
#include <Inventor/Xt/SoInventorXtLibName.h>

#include <Inventor/SoModule.h>
SO_MODULE_HEADER(SoInventorXt, __INVENTORXTDLL)

class SbPList;
class SoXtEventHandler;
class SoAction;

/**
 * Routines for Open Inventor/Xt compatibility.
 *
 * @ingroup Xt
 *
 * @DESCRIPTION
 *   The SoXt class initializes Open Inventor for use with the Xt toolkit and Motif.
 *   SoXt::init() must be called in order for Open Inventor to work properly with Xt
 *   SoXt::finish() should be called to clean up static memory allocations.
 *
 *   SoXt::mainLoop() must be called in order for extension device events to be
 *   passed to Open Inventor render areas. The other methods are convenience
 *   functions.
 *
 *   Refer to the SoXtComponent reference pages for examples on how this class should
 *   be used when using Open Inventor Xt components.
 *
 * @SEE_ALSO
 *    SoXtComponent
 *
 *
 */
class INVENTORXT_API SoXt {

 public:
  /**
   * This is called to initialize Open Inventor and Xt, and bind Open Inventor with X
   * events handling so that Open Inventor sensors will work correctly. This returns
   * the top level shell widget. This method calls SoDB::init(),
   * SoNodeKit::init(), and SoInteraction::init() and creates an
   * initial window.
   */
  static SoWidget init(const char *appName,
                     const char *className = "Inventor");

  /**
   * This alternate form of init allows the application to initialize Xt. The passed
   * widget should be the top level widget returned from the Xt initialization. This
   * method will call SoDB::init(), SoNodeKit::init(), and
   * SoInteraction::init().
   */
  static void init(SoWidget topLevelWidget);

#if SoDEPRECATED_BEGIN(10000)
   /*
    * @UNICODE_WARNING
    */
  SoDEPRECATED_METHOD(10000, "Use SoXt::init( appName, className ) instead.")
  static SoWidget threadInit(const char *appName,
                           const char *className = "Inventor");

  SoDEPRECATED_METHOD(10000, "Use SoXt::init( topLevelWidget ) instead.")
  static void threadInit(SoWidget topLevelWidget);
#endif /** @DEPRECATED_END */

  /**
   * Returns TRUE if SoXt module is currently initialized.
   */
  static bool isInitialized();

  /**
   * Frees Open Inventor's internal static memory
   * allocations. This avoids false positives from memory
   * leak checking software. We recommend calling this method
   * and it should be the last Open Inventor method called by
   * the application. This method calls SoDB::finish(),
   * SoNodeKit::finish(), and SoInteraction::finish().
   *
   *@B Note@b: Open Inventor objects should be destroyed before you call this method.
   *
   * For example:
   * @TABLE_1B
   *  @TR @B Wrong Open Inventor Ending@b
   *  @TD @B Safe Open Inventor Endings@b
   *  @TR \code
   * void main() {
   *   SoWidget myW = SoXt::init("");
   *   SoXtExaminerViewer viewer(myW);
   *   ....
   *   ....
   *   SoXt::mainLoop();
   *   SoXt::finish();
   * }
   *  \endcode
   *  @TD
   *    @TABLE_0B
   *    @TR \code
   * void runApp() {
   *   SoXtExaminerViewer viewer(myW);
   *   ....
   *   ....
   *   SoXt::mainLoop();
   * }
   *
   * void main () {
   *   SoWidget myW = SoXt::init("");
   *   runApp();
   *   SoXt::finish();
   * }
   * \endcode
   * @TD \code
   * void main () {
   *   SoWidget myW = SoXt::init("");
   *   SoXtExaminerViewer* viewer
   *          = new SoXtExaminerViewer(myW);
   *   ....
   *   ....
   *   SoXt::mainLoop();
   *   delete viewer;
   *   SoXt::finish();
   *  }
   * \endcode
   *     @TABLE_END
   * @TR
   * SoXt doesn't end properly: SoXtExaminerViewer is destroyed after the finish() method has been called.
   * @TD
   * The SoXtExaminerViewer (that uses OpenInventor) is destroyed before calling the finish() method.
   *     @TABLE_END
   */
  static void finish();

  /**
   * Enters the main event loop and waits until exit() is called.
   * Returns the value that was passed to exit().
   *
   * It calls nextEvent() and dispatchEvent() to retrieve and dispatch events.
   */
  static int mainLoop();

  /**
   * Tells the main event loop to exit with a return code.
   *
   * After this function has been called, the mainLoop() function returns returnCode.
   * If the event loop is not running, this function does nothing.
   *
   * By convention, a returnCode of 0 means success, and any non-zero value indicates an error.
   */
  static void exit(int returnCode = 0);

  /**
   * Gets the nextEvent by calling XtAppNextEvent(). The @B appContext @b can be had by
   * calling SoXt::getAppContext().
   */
  static void nextEvent(XtAppContext appContext, XEvent *event)
    { XtAppNextEvent(appContext, event); }

  /**
   * Dispatches the passed event to a handler. This returns TRUE if a handler was
   * found, else it returns FALSE.
   */
  static Boolean dispatchEvent(XEvent *event);

  /**
   * This method is included for portability only.
   */
  static XtAppContext getAppContext();

  /**
   * This method is included for portability only.
   */
  static Display *getDisplay();

  /**
   * Returns information based on the initial widget returned by or passed to init.
   */
  static SoWidget getTopLevelWidget();

  //
  // Convenience routines
  //

  /**
   * Convenience routine to show the passed widget.
   * This includes any children the window may have.
   */
  static void show(SoWidget widget);

  /**
   * Convenience routine to hide the passed widget.
   * This includes any children the window may have.
   */
  static void hide(SoWidget widget);

  /**
   * Convenience routine for encoding a character string as an
   * @B XmString @b. decodeString() is used for decoding an @B XmString @b back to
   * a character string.
   * (@B XmString @b is a Motif string). The application is responsible for freeing
   * up the memory pointed to by the return value. Use @B XmStringFree @b() to
   * free an @B XmString @b.
   */
  static XmString encodeString(char *s);

  /**
   * Convenience routine for decoding an @B XmString @b back to a character string.
   * encodeString() is used for encoding a character string as an
   * @B XmString @b.
   * (@B XmString @b is a Motif string). The application is responsible for freeing
   * up the memory pointed to by the return value. Use
   * @B free @b() to free a character pointer.
   */
  static char *decodeString(XmString xs);

  /**
   * Convenience routine to set the size of the given window.
   */
  static void setWidgetSize(SoWidget w, const SbVec2s &size);

  /**
   * Convenience routine to get the size of the given window.
   */
  static SbVec2s getWidgetSize(SoWidget w);

  /**
   * Convenience routine which will return the topmost window containing the given
   * widget. The widget tree is traversed up until the last widget is found using
   * @B GetParent @b.
   */
  static SoWidget getShellWidget(SoWidget w);

  /**
   * Convenience routine which brings a simple Xt error dialog box displaying the
   * given error string(s) and window title. The OK button, which destroys the
   * dialog, is the only button displayed.
   */
  static void createSimpleErrorDialog(SoWidget widget, char *dialogTitle,
                                      char *errorStr1, char *errorStr2 = NULL);

  /**
   * Convenience routine which gets visual args for the popup planes. These args can
   * then be passed in to @B XmCreatePulldownMenu @b() or @B XmCreatePopupMenu @b()
   * to create menus in the popup planes. addColormapToShell() has to be
   * called on the main popup window to set the proper color map.
   */
  static void getPopupArgs(Display *d, int scr, ArgList args, int *n);

  /**
   * Convenience routine which will register map/unmap callbacks to load and unload
   * the pulldown menu color map right before the menu is about to be posted. This
   * should be called when creating pulldown or popup menus in the overlays. This
   * will make sure that the right color map is loaded into the shell widget (to make
   * the pulldown/popup look right) and remove it when no longer needed (to make sure
   * the OpenGL overlay widget color map is correctly loaded for 8 bit machines).
   */
  static void registerColormapLoad(SoWidget widget, SoWidget shell);

  /**
   * Convenience routine to insert the given widget colormap onto the supplied
   * shell widget. This will not replace the existing installed colormaps (or list of
   * windows), but instead insert the new colormap first into the existing list using
   * @B XGetWMColormapWindows @b() and @B XSetWMColormapWindows @b().
   */
  static void addColormapToShell(SoWidget widget, SoWidget shell);

  /**
   * Convenience routine to remove the given widget colormap from the supplied
   * shell widget.
   */
  static void removeColormapFromShell(SoWidget widget, SoWidget shell);

 SoINTERNAL public:
  // Add/remove the passed event handler for X extension device events
  // (Xt does not handle extension events.)
  // Extension event types are queried from the server at runtime.
  static void addExtensionEventHandler(SoWidget w,
                                       int extensionEventType,
                                       XtEventHandler proc,
                                       XtPointer clientData);
  static void removeExtensionEventHandler(SoWidget w,
                                          int extensionEventType,
                                          XtEventHandler proc,
                                          XtPointer clientData);

  // This method is an acces method to label (Widgets).

  // This method is an acces method to label ( Widgets ).
  // Begin
  static SoWidget getwidget( unsigned int whatisit );
  // End

  static void canExit(SbBool ce);

  static void setEventHandler();

  static SoXtEventHandler *eventHandler;

 protected:
  static void             getExtensionEventHandler(
                                                   XEvent *event,
                                                   SoWidget &w,
                                                   XtEventHandler &proc,
                                                   XtPointer &clientData);

 private:
  /** 
   * Active main loop used for graphical tests (doesn't wait for user event
   * so it can exits when N frames have been rendered without user interaction) 
   */
  static void activeLoop();
  
  static int s_returnCode;

  static SoWidget           mainWidget;
  static bool             m_internalApp;
  static SbBool           m_canExit;

  static SbPList          *handlerList;

  // Begin
  // Widgets for localisation.
  static SoWidget label[155];

  static void localisationlabel(SoWidget parent);
  // End

  // setup display in Inventor for GL extensions check
  static void setupInventorGLDisplay();
  
  static int s_initRefCount;
  static const char *s_versionString;
};

#endif  /* _SO_XT_ */

#endif // SOQT

