/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Isaacs (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifdef _WIN32
#  include <Inventor/Win/SoWinLightSliderSet.h>
#else // _WIN32

#ifndef _SO_XT_LIGHT_SLIDER_SET_
#define _SO_XT_LIGHT_SLIDER_SET_

#include <Inventor/Xt/SoXtSliderSet.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoXtLightSliderSet
//
//  For editing light source nodes.
//
//  The SoXtLightSliderSet allocates:
//     1 SoXtLightIntensitySliderModule   (for editing light intensity)
//     1 SoXtLightColorSliderModule       (for editing light color)
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Component with Motif sliders for editing SoLight nodes.
 * 
 * @ingroup Xt
 * 
 * @DESCRIPTION
 *   This class is used to manipulate the intensity and color of an SoLight node
 *   using an arrangement of Motif sliders and buttons.
 * 
 * @RESOURCES
 * \verbatim
     !!------------------------------------------------
     !! Light Slider Set
     !!------------------------------------------------
     *IvLightSliderColor.labelString: COLOR
     *IvLightSliderRed.labelString: Red
     *IvLightSliderGreen.labelString: Green
     *IvLightSliderBlue.labelString: Blue
     *IvLightSliderIntensity1.labelString: INTENSITY
     *IvLightSliderIntensity2.labelString: Intensity
   \endverbatim
 * 
 * @SEE_ALSO
 *    SoXtSliderSet,
 *    SoXtSliderSetBase,
 *    SoXtComponent,
 *    SoLight,
 *    SoNode
 * 
 * 
 */ 

SoINTERNAL class INVENTORXT_API SoXtLightSliderSet : public SoXtSliderSet {
 public:
  /**
   * Constructor. At construction time the light node to edit can be
   * supplied. 
   */
  SoXtLightSliderSet( 
                     SoWidget parent = NULL,
                     const char *name = NULL, 
                     SbBool buildInsideParent = TRUE,
                     SoNode *newEditNode = NULL );
  /**
   * Destructor.
   */
  ~SoXtLightSliderSet();
    
 protected:

  // This constructor takes a boolean whether to build the widget now.
  // Subclasses can pass FALSE, then call the buildWidget() method on
  // this class when they are ready for it to be built.
  SoEXTENDER
    SoXtLightSliderSet(
                       SoWidget parent,
                       const char *name, 
                       SbBool buildInsideParent, 
                       SoNode *newEditNode,
                       SbBool buildNow);
    
  SoWidget      buildWidget(SoWidget parent);
  
  // this is called by both constructors
  void constructorCommon(SbBool buildNow);

};

#endif /* _SO_XT_LIGHT_SLIDER_SET_ */

#endif // _WIN32


