/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Isaacs (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifdef _WIN32
#  include <Inventor/Win/SoWinSliderSet.h>
#else // _WIN32

#ifndef _SO_XT_SLIDER_SET_
#define _SO_XT_SLIDER_SET_

#include <Inventor/Xt/SoXtSliderSetBase.h>

#define SLIDER_SET_DEFAULT_BORDER_WIDTH 3

///////////////////////////////////////////////////////////////////////
//
// class: SoXtSliderSet
//
///////////////////////////////////////////////////////////////////////

/**
 * Base class for Motif-only slider components.
 * 
 * @ingroup Xt
 * 
 * @DESCRIPTION
 *   This class is used as a base class for all editors which use sets of Motif
 *   sliders to edit fields in an Open Inventor scene graph node. The editor consists
 *   of a number of sliders each of which may change a different value in a field.
 *   This class is not meant to be instanced by programmers who want to use an editor
 *   in a program. It should only be used as a base class when designing new editors.
 *   
 *   This class has no public methods. The internal methods deal with managing the
 *   layout of the subcomponents.
 * 
 * @RESOURCES
 * \verbatim
     !!------------------------------------------------
     !! For All Sliders
     !!------------------------------------------------
     *IvSlidersMin.labelString: min
     *IvSlidersMax.labelString: max
     *IvSlidersStyle.labelString: style
   \endverbatim
 * 
 * @SEE_ALSO
 *    SoXtSliderSetBase,
 *    SoXtComponent,
 *    SoNode,
 *    SoXtLightSliderSet,
 *    SoXtMaterialSliderSet,
 *    SoXtTransformSliderSet
 * 
 * 
 */ 

SoINTERNAL class INVENTORXT_API SoXtSliderSet : public SoXtSliderSetBase {
 public:
  // internal:
  void updateLayout();        // Called after button presses that may
  // cause the size or layout of the SoXtSliderSet 
  // to be altered.
                                  
 protected:
  SoXtSliderSet(
                SoWidget parent,
                const char *name, 
                SbBool buildInsideParent,
                SoNode *newEditNode);
  ~SoXtSliderSet();
  SoWidget _parentShellWidget;  // since this class can resize itself when
  // buttons are pressed, it needs to know
  // about its parent shell, so that it
  // query and change the size.
};

#endif // _SO_XT_SLIDER_SET_

#endif // _WIN32


