/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : David Mott (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifdef SOQT
#  include <Inventor/Qt/devices/SoQtDevice.h>
#elif defined _WIN32
#  include <Inventor/Win/devices/SoWinDevice.h>
#else // _WIN32

#ifndef  _SO_XT_DEVICE_
#define  _SO_XT_DEVICE_

#include <X11/Intrinsic.h>
#include <Inventor/SbLinear.h>
#include <Inventor/events/SoEvent.h>
#include <Inventor/Xt/SoXtDef.h>

/**
 * Abstract base class for input devices
 * 
 * @ingroup Xt
 * 
 * @DESCRIPTION
 *   This is the abstract base class for devices in the Open Inventor Xt component
 *   and utility library. When a device is registered with an SoXtRenderArea, the
 *   device is able to generate messages in the render area window.
 *
 *   Used internally by SoXtRenderArea and derived classes.  Can also be used
 *   by the application to translate system events into SoEvent objects.
 * 
 * @SEE_ALSO
 *    SoXtMouse,
 *    SoXtKeyboard,
 *    SoXtSpaceBall,
 *    SoXtInputFocus,
 *    SoXtRenderArea
 */
class INVENTORXT_API SoXtDevice {
 public:
  /**
   * Enables the device for the passed widget. When enabled, the callback
   * function @B f @b will be invoked when events occur in the window. @B data @b
   * is the @B clientData @b which will be passed.
   */
  virtual void        enable(SoWidget w, XtEventHandler f,
                             XtPointer data, Window win = (Window)NULL) = 0;
  /**
   * Disables the device for the passed widget. 
   */
  virtual void        disable(SoWidget w, XtEventHandler f, XtPointer data) = 0;
    
  /**
   * Attempts to convert the passed event into an SoEvent. @BR
   * Returns a pointer to an internal SoEvent object owned by the class.
   * Do not delete this object. If the message was not generated by this 
   * device, then NULL is returned.
   */
  virtual const SoEvent * translateEvent(XAnyEvent *xevent) = 0;

  /**
   * Sets the size of the window this device is registered for. This allows
   * the device to correctly convert position information from X window coordinates
   * (origin at top left) to Open Inventor window coordinates (origin at bottom
   * left). (SoXtRenderArea will automatically call this method for each device
   * registered on it whenever the window size changes.) Note: Setting the window
   * size only affects the size as perceived by the device and not the actual window
   * size.
   */
  void                setWindowSize(const SbVec2s &s) { winSize = s; }
  /**
   * Gets the size of the window this device is registered for. 
   */
  const SbVec2s &     getWindowSize() const           { return winSize; }

  virtual ~SoXtDevice() {};

 protected:
  /**
   *  Set the window coordinate from the passed x,y value. This will flip
   *  the y value to convert from X coordinates to So coordinates.
   *  Note : The position is float to handle particular use cases when a desktop is magnified
   *  on a wall of screens using ScaleViz in correlation with a tracker
   *  device calibrated for this wall.
   */
  inline void         setEventPosition(SoEvent *event, float x, float y) const;

  /**
   *  
   *  Set common event properties.
   */
  void setCommonEventProperties(SoEvent *event,
				Display* display, Window root,
				int x, int y, 
				int x_root, int y_root,
				Time time, unsigned int state);
    
 private:
  SbVec2s             winSize;    // size of the window this device works in

};

// Inline functions
void
SoXtDevice::setEventPosition(SoEvent *event, float x, float y) const
{
  event->setPosition(SbVec2f(x, (((float)winSize[1]) - 1.f) - y));
}

#endif /* _SO_XT_DEVICE_ */

#endif // _WIN32


